/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import org.hawkular.metrics.clients.ptrans.Configuration;
import org.hawkular.metrics.clients.ptrans.MetricBatcher;
import org.hawkular.metrics.clients.ptrans.backend.RestForwardingHandler;
import org.hawkular.metrics.clients.ptrans.collectd.CollectdEventHandler;
import org.hawkular.metrics.clients.ptrans.collectd.event.CollectdEventsDecoder;
import org.hawkular.metrics.clients.ptrans.collectd.packet.CollectdPacketDecoder;

public class CollectdChannelInitializer
extends ChannelInitializer<Channel> {
    private final Configuration configuration;
    private final RestForwardingHandler forwardingHandler;

    public CollectdChannelInitializer(Configuration configuration, RestForwardingHandler forwardingHandler) {
        this.configuration = configuration;
        this.forwardingHandler = forwardingHandler;
    }

    public void initChannel(Channel socketChannel) throws Exception {
        ChannelPipeline pipeline = socketChannel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new CollectdPacketDecoder()});
        pipeline.addLast(new ChannelHandler[]{new CollectdEventsDecoder()});
        pipeline.addLast(new ChannelHandler[]{new CollectdEventHandler()});
        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.configuration.getMaximumBatchDelay(), 0, 0)});
        pipeline.addLast(new ChannelHandler[]{new MetricBatcher("collectd", this.configuration.getMinimumBatchSize())});
        pipeline.addLast(new ChannelHandler[]{this.forwardingHandler});
    }
}

