/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.HttpServerFileUploadImpl;
import io.vertx.core.http.impl.NettyFileUpload;
import java.nio.charset.Charset;
import java.util.function.Supplier;

class NettyFileUploadDataFactory
extends DefaultHttpDataFactory {
    final Vertx vertx;
    final HttpServerRequest request;
    final Supplier<Handler<HttpServerFileUpload>> lazyUploadHandler;

    NettyFileUploadDataFactory(Vertx vertx, HttpServerRequest request, Supplier<Handler<HttpServerFileUpload>> lazyUploadHandler) {
        super(false);
        this.vertx = vertx;
        this.request = request;
        this.lazyUploadHandler = lazyUploadHandler;
    }

    @Override
    public FileUpload createFileUpload(HttpRequest httpRequest, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        HttpServerFileUploadImpl upload = new HttpServerFileUploadImpl(this.vertx, this.request, name, filename, contentType, contentTransferEncoding, charset, size);
        NettyFileUpload nettyUpload = new NettyFileUpload(upload, name, filename, contentType, contentTransferEncoding, charset);
        Handler<HttpServerFileUpload> uploadHandler = this.lazyUploadHandler.get();
        if (uploadHandler != null) {
            uploadHandler.handle(upload);
        }
        return nettyUpload;
    }
}

