/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.AsyncResultHandler;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.NetSocketStream;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.AsyncResolveConnectHelper;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.HandlerManager;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import io.vertx.core.net.impl.VertxNetHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;

public class NetServerImpl
implements NetServer,
Closeable,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    private final VertxInternal vertx;
    private final NetServerOptions options;
    private final ContextImpl creatingContext;
    private final SSLHelper sslHelper;
    private final Map<Channel, NetSocketImpl> socketMap = new ConcurrentHashMap<Channel, NetSocketImpl>();
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<Handler<NetSocket>> handlerManager = new HandlerManager(this.availableWorkers);
    private final Queue<Runnable> bindListeners = new LinkedList<Runnable>();
    private final NetSocketStreamImpl connectStream = new NetSocketStreamImpl();
    private final boolean logEnabled;
    private ChannelGroup serverChannelGroup;
    private volatile boolean listening;
    private volatile ServerID id;
    private NetServerImpl actualServer;
    private AsyncResolveConnectHelper bindFuture;
    private volatile int actualPort;
    private ContextImpl listenContext;
    private TCPMetrics metrics;

    public NetServerImpl(VertxInternal vertx, NetServerOptions options) {
        this.vertx = vertx;
        this.options = new NetServerOptions(options);
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.creatingContext = vertx.getContext();
        this.logEnabled = options.getLogActivity();
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use NetServer in a multi-threaded worker verticle");
            }
            this.creatingContext.addCloseHook(this);
        }
    }

    @Override
    public NetServer connectHandler(Handler<NetSocket> handler) {
        this.connectStream.handler((Handler)handler);
        return this;
    }

    @Override
    public Handler<NetSocket> connectHandler() {
        return this.connectStream.handler();
    }

    @Override
    public NetSocketStream connectStream() {
        return this.connectStream;
    }

    @Override
    public NetServer listen(int port, String host) {
        return this.listen(port, host, null);
    }

    @Override
    public NetServer listen(int port) {
        return this.listen(port, "0.0.0.0", null);
    }

    @Override
    public NetServer listen(int port, Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(port, "0.0.0.0", listenHandler);
    }

    @Override
    public NetServer listen() {
        this.listen(null);
        return this;
    }

    @Override
    public synchronized NetServer listen(Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(this.options.getPort(), this.options.getHost(), listenHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized NetServer listen(int port, String host, Handler<AsyncResult<NetServer>> listenHandler) {
        if (this.connectStream.handler() == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        this.listenContext = this.vertx.getOrCreateContext();
        Map<ServerID, NetServerImpl> map = this.vertx.sharedNetServers();
        synchronized (map) {
            this.actualPort = port;
            this.id = new ServerID(port, host);
            NetServerImpl shared = this.vertx.sharedNetServers().get(this.id);
            if (shared == null || port == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group(this.availableWorkers);
                bootstrap.channel(NioServerSocketChannel.class);
                this.sslHelper.validate(this.vertx);
                bootstrap.childHandler(new ChannelInitializer<Channel>(){

                    @Override
                    protected void initChannel(Channel ch) throws Exception {
                        if (NetServerImpl.this.connectStream.isPaused()) {
                            ch.close();
                            return;
                        }
                        ChannelPipeline pipeline = ch.pipeline();
                        if (NetServerImpl.this.sslHelper.isSSL()) {
                            SslHandler sslHandler = NetServerImpl.this.sslHelper.createSslHandler(NetServerImpl.this.vertx);
                            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                        }
                        if (NetServerImpl.this.logEnabled) {
                            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
                        }
                        if (NetServerImpl.this.sslHelper.isSSL()) {
                            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                        }
                        if (NetServerImpl.this.options.getIdleTimeout() > 0) {
                            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, NetServerImpl.this.options.getIdleTimeout()));
                        }
                        pipeline.addLast("handler", (ChannelHandler)new ServerHandler(ch));
                    }
                });
                this.applyConnectionOptions(bootstrap);
                if (this.connectStream.handler() != null) {
                    this.handlerManager.addHandler(this.connectStream.handler(), this.listenContext);
                }
                try {
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, port, host, bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (res.succeeded()) {
                            Channel ch = (Channel)res.result();
                            log.trace("Net server listening on " + host + ":" + ch.localAddress());
                            this.actualPort = ((InetSocketAddress)ch.localAddress()).getPort();
                            this.id = new ServerID(this.actualPort, this.id.host);
                            this.serverChannelGroup.add(ch);
                            this.vertx.sharedNetServers().put(this.id, this);
                            this.metrics = this.vertx.metricsSPI().createMetrics(this, (SocketAddress)new SocketAddressImpl(this.id.port, this.id.host), this.options);
                        } else {
                            this.vertx.sharedNetServers().remove(this.id);
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(v -> listenHandler.handle(Future.failedFuture(t)));
                    } else {
                        log.error(t);
                    }
                    this.listening = false;
                    return this;
                }
                if (port != 0) {
                    this.vertx.sharedNetServers().put(this.id, this);
                }
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.actualPort = shared.actualPort();
                this.metrics = this.vertx.metricsSPI().createMetrics(this, (SocketAddress)new SocketAddressImpl(this.id.port, this.id.host), this.options);
                if (this.connectStream.handler() != null) {
                    this.actualServer.handlerManager.addHandler(this.connectStream.handler(), this.listenContext);
                }
            }
            this.actualServer.bindFuture.addListener(res -> {
                if (listenHandler != null) {
                    Future<NetServerImpl> ares;
                    if (res.succeeded()) {
                        ares = Future.succeededFuture(this);
                    } else {
                        this.listening = false;
                        ares = Future.failedFuture(res.cause());
                    }
                    this.listenContext.runOnContext(v -> listenHandler.handle(ares));
                } else if (res.failed()) {
                    log.error((Object)"Failed to listen", res.cause());
                    this.listening = false;
                }
            });
        }
        return this;
    }

    @Override
    public synchronized void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Handler<AsyncResult<Void>> done) {
        if (this.connectStream.endHandler() != null) {
            final Handler endHandler = this.connectStream.endHandler;
            this.connectStream.endHandler = null;
            final AsyncResultHandler<Void> next = done;
            done = new AsyncResultHandler<Void>(){

                @Override
                public void handle(AsyncResult<Void> event) {
                    if (event.succeeded()) {
                        endHandler.handle(event.result());
                    }
                    if (next != null) {
                        next.handle(event);
                    }
                }
            };
        }
        ContextImpl context = this.vertx.getOrCreateContext();
        if (!this.listening) {
            if (done != null) {
                this.executeCloseDone(context, done, null);
            }
            return;
        }
        this.listening = false;
        Map<ServerID, NetServerImpl> map = this.vertx.sharedNetServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.handlerManager.removeHandler(this.connectStream.handler(), this.listenContext);
                if (this.actualServer.handlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(context, (Handler<AsyncResult<Void>>)done, null);
                    }
                } else {
                    this.actualServer.actualClose(context, (Handler<AsyncResult<Void>>)done);
                }
            }
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this);
        }
    }

    @Override
    public synchronized int actualPort() {
        return this.actualPort;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null && this.metrics.isEnabled();
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void applyConnectionOptions(ServerBootstrap bootstrap) {
        bootstrap.childOption(ChannelOption.TCP_NODELAY, this.options.isTcpNoDelay());
        if (this.options.getSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, this.options.getSendBufferSize());
        }
        if (this.options.getReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, this.options.getReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(this.options.getReceiveBufferSize()));
        }
        if (this.options.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, this.options.getSoLinger());
        }
        if (this.options.getTrafficClass() != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, this.options.getTrafficClass());
        }
        bootstrap.childOption(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, this.options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_REUSEADDR, this.options.isReuseAddress());
        if (this.options.getAcceptBacklog() != -1) {
            bootstrap.option(ChannelOption.SO_BACKLOG, this.options.getAcceptBacklog());
        }
    }

    private void actualClose(ContextImpl closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedNetServers().remove(this.id);
        }
        ContextImpl currCon = this.vertx.getContext();
        for (NetSocketImpl sock : this.socketMap.values()) {
            sock.close();
        }
        if (this.vertx.getContext() != currCon) {
            throw new IllegalStateException("Context was changed");
        }
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)cg -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
            this.executeCloseDone(closeContext, done, fut.cause());
        }));
    }

    private void executeCloseDone(ContextImpl closeContext, Handler<AsyncResult<Void>> done, Exception e) {
        if (done != null) {
            Future fut = e == null ? Future.succeededFuture() : Future.failedFuture(e);
            closeContext.runOnContext(v -> done.handle(fut));
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class NetSocketStreamImpl
    implements NetSocketStream {
        private Handler<NetSocket> handler;
        private boolean paused;
        private Handler<Void> endHandler;

        private NetSocketStreamImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<NetSocket> handler() {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                return this.handler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isPaused() {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                return this.paused;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<Void> endHandler() {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                return this.endHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetSocketStreamImpl handler(Handler<NetSocket> handler) {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                if (NetServerImpl.this.listening) {
                    throw new IllegalStateException("Cannot set connectHandler when server is listening");
                }
                this.handler = handler;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetSocketStreamImpl pause() {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                if (!this.paused) {
                    this.paused = true;
                }
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetSocketStreamImpl resume() {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                if (this.paused) {
                    this.paused = false;
                }
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetSocketStreamImpl endHandler(Handler<Void> endHandler) {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                this.endHandler = endHandler;
                return this;
            }
        }

        @Override
        public NetSocketStreamImpl exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }

    private class ServerHandler
    extends VertxNetHandler {
        public ServerHandler(Channel ch) {
            super(ch, NetServerImpl.this.socketMap);
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            Channel ch = ctx.channel();
            EventLoop worker = ch.eventLoop();
            HandlerHolder<Handler<NetSocket>> handler = NetServerImpl.this.handlerManager.chooseHandler(worker);
            if (handler == null) {
                return;
            }
            if (NetServerImpl.this.sslHelper.isSSL()) {
                SslHandler sslHandler = ch.pipeline().get(SslHandler.class);
                io.netty.util.concurrent.Future<Channel> fut = sslHandler.handshakeFuture();
                fut.addListener(future -> {
                    if (future.isSuccess()) {
                        this.connected(ch, handler);
                    } else {
                        log.error("Client from origin " + ch.remoteAddress() + " failed to connect over ssl: " + future.cause());
                    }
                });
            } else {
                this.connected(ch, handler);
            }
        }

        private void connected(Channel ch, HandlerHolder<Handler<NetSocket>> handler) {
            ContextImpl.setContext(handler.context);
            NetSocketImpl sock = new NetSocketImpl(NetServerImpl.this.vertx, ch, handler.context, NetServerImpl.this.sslHelper, false, NetServerImpl.this.metrics, null);
            NetServerImpl.this.socketMap.put(ch, sock);
            VertxNetHandler netHandler = ch.pipeline().get(VertxNetHandler.class);
            netHandler.conn = sock;
            handler.context.executeFromIO(() -> {
                sock.setMetric(NetServerImpl.this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
                ((Handler)handler.handler).handle(sock);
            });
        }
    }
}

