/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.ext.hawkular.impl.HttpClientConnectionsMeasurements;
import io.vertx.ext.hawkular.impl.HttpClientMetricsSupplier;
import io.vertx.ext.hawkular.impl.HttpClientRequestMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class HttpClientMetricsImpl
implements HttpClientMetrics<HttpClientRequestMetrics, SocketAddress, SocketAddress, Void, Void> {
    private final ConcurrentMap<SocketAddress, HttpClientConnectionsMeasurements> connectionsMeasurements = new ConcurrentHashMap<SocketAddress, HttpClientConnectionsMeasurements>(0);
    private final HttpClientMetricsSupplier httpClientMetricsSupplier;

    public HttpClientMetricsImpl(HttpClientMetricsSupplier httpClientMetricsSupplier) {
        this.httpClientMetricsSupplier = httpClientMetricsSupplier;
        httpClientMetricsSupplier.register(this);
    }

    @Override
    public Void createEndpoint(String host, int port, int maxPoolSize) {
        return null;
    }

    @Override
    public void closeEndpoint(String host, int port, Void endpointMetric) {
    }

    @Override
    public Void enqueueRequest(Void endpointMetric) {
        return null;
    }

    @Override
    public void dequeueRequest(Void endpointMetric, Void taskMetric) {
    }

    @Override
    public void endpointConnected(Void endpointMetric, SocketAddress socketMetric) {
    }

    @Override
    public void endpointDisconnected(Void endpointMetric, SocketAddress socketMetric) {
    }

    @Override
    public void requestEnd(HttpClientRequestMetrics requestMetric) {
    }

    @Override
    public void responseBegin(HttpClientRequestMetrics requestMetric, HttpClientResponse response) {
    }

    @Override
    public HttpClientRequestMetrics requestBegin(Void endpointMetric, SocketAddress key, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.requestBegin();
        }
        HttpClientRequestMetrics httpClientRequestMetrics = new HttpClientRequestMetrics(key);
        httpClientRequestMetrics.resetTimer();
        return httpClientRequestMetrics;
    }

    @Override
    public HttpClientRequestMetrics responsePushed(Void endpointMetric, SocketAddress key, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
        return this.requestBegin(null, key, localAddress, remoteAddress, request);
    }

    @Override
    public void requestReset(HttpClientRequestMetrics requestMetric) {
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(requestMetric.getAddress());
        if (measurements != null) {
            measurements.requestReset();
        }
    }

    @Override
    public void responseEnd(HttpClientRequestMetrics requestMetric, HttpClientResponse response) {
        long responseTime = requestMetric.elapsed();
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(requestMetric.getAddress());
        if (measurements != null) {
            measurements.responseEnd(responseTime);
        }
    }

    @Override
    public SocketAddress connected(Void endpointMetric, SocketAddress key, WebSocket webSocket) {
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.incrementWsConnectionCount();
        }
        return key;
    }

    @Override
    public void disconnected(SocketAddress key) {
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.decrementWsConnectionCount();
        }
    }

    @Override
    public SocketAddress connected(SocketAddress remoteAddress, String remoteName) {
        SocketAddressImpl key = new SocketAddressImpl(remoteAddress.port(), remoteName);
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements == null) {
            measurements = this.connectionsMeasurements.computeIfAbsent(key, address -> new HttpClientConnectionsMeasurements());
        }
        measurements.incrementConnections();
        return key;
    }

    @Override
    public void disconnected(SocketAddress key, SocketAddress remoteAddress) {
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.decrementConnections();
        }
    }

    @Override
    public void bytesRead(SocketAddress key, SocketAddress remoteAddress, long numberOfBytes) {
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.addBytesReceived(numberOfBytes);
        }
    }

    @Override
    public void bytesWritten(SocketAddress key, SocketAddress remoteAddress, long numberOfBytes) {
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.addBytesSent(numberOfBytes);
        }
    }

    @Override
    public void exceptionOccurred(SocketAddress key, SocketAddress remoteAddress, Throwable t) {
        HttpClientConnectionsMeasurements measurements = (HttpClientConnectionsMeasurements)this.connectionsMeasurements.get(key);
        if (measurements != null) {
            measurements.incrementErrorCount();
        }
    }

    public Map<SocketAddress, HttpClientConnectionsMeasurements.Snapshot> getMeasurementsSnapshot() {
        return this.connectionsMeasurements.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((HttpClientConnectionsMeasurements)e.getValue()).getSnapshot()));
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
        this.httpClientMetricsSupplier.unregister(this);
    }
}

