/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.ClientHandler;
import io.vertx.core.http.impl.ConnectionManager;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.Waiter;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class Http1xPool
implements ConnectionManager.Pool<ClientConnection> {
    private final ConnectionManager.ConnQueue queue;
    private final HttpClientImpl client;
    private final HttpClientMetrics metrics;
    private final Map<Channel, HttpClientConnection> connectionMap;
    private final boolean pipelining;
    private final boolean keepAlive;
    private final int pipeliningLimit;
    private final boolean ssl;
    private final HttpVersion version;
    private final Set<ClientConnection> allConnections = new HashSet<ClientConnection>();
    private final Queue<ClientConnection> availableConnections = new ArrayDeque<ClientConnection>();
    private final int maxSockets;

    public Http1xPool(HttpClientImpl client, HttpClientMetrics metrics, HttpClientOptions options, ConnectionManager.ConnQueue queue, Map<Channel, HttpClientConnection> connectionMap, HttpVersion version, int maxSockets) {
        this.queue = queue;
        this.version = version;
        this.client = client;
        this.metrics = metrics;
        this.pipelining = options.isPipelining();
        this.keepAlive = options.isKeepAlive();
        this.pipeliningLimit = options.getPipeliningLimit();
        this.ssl = options.isSsl();
        this.connectionMap = connectionMap;
        this.maxSockets = maxSockets;
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    @Override
    public ClientConnection pollConnection() {
        return this.availableConnections.poll();
    }

    @Override
    public boolean canCreateConnection(int connCount) {
        return connCount < this.maxSockets;
    }

    @Override
    public HttpClientStream createStream(ClientConnection conn) {
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(ClientConnection conn) {
        ConnectionManager.ConnQueue connQueue = this.queue;
        synchronized (connQueue) {
            Waiter waiter = this.queue.getNextWaiter();
            if (waiter != null) {
                this.queue.deliverStream(conn, waiter);
            } else if (conn.getOutstandingRequestCount() == 0) {
                this.availableConnections.add(conn);
            }
        }
    }

    void requestEnded(ClientConnection conn) {
        ContextImpl context = conn.getContext();
        context.runOnContext(v -> {
            if (this.pipelining && conn.getOutstandingRequestCount() < this.pipeliningLimit) {
                this.recycle(conn);
            }
        });
    }

    void responseEnded(ClientConnection conn, boolean close) {
        if (!this.keepAlive || close) {
            conn.close();
        } else {
            ContextImpl ctx = conn.getContext();
            ctx.runOnContext(v -> {
                if (conn.getCurrentRequest() == null) {
                    this.recycle(conn);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createConn(HttpVersion version, ContextImpl context, int port, String host, Channel ch, Waiter waiter) {
        ClientConnection conn = new ClientConnection(version, this.client, this.queue.metric, ch, this.ssl, host, port, context, this, this.metrics);
        this.metrics.endpointConnected(this.queue.metric, conn.metric());
        ClientHandler handler = ch.pipeline().get(ClientHandler.class);
        handler.conn = conn;
        ConnectionManager.ConnQueue connQueue = this.queue;
        synchronized (connQueue) {
            this.allConnections.add(conn);
        }
        this.connectionMap.put(ch, conn);
        waiter.handleConnection(conn);
        this.queue.deliverStream(conn, waiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectionClosed(ClientConnection conn) {
        ConnectionManager.ConnQueue connQueue = this.queue;
        synchronized (connQueue) {
            this.allConnections.remove(conn);
            this.availableConnections.remove(conn);
            this.queue.connectionClosed();
        }
        this.metrics.endpointDisconnected(this.queue.metric, conn.metric());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAllConnections() {
        HashSet<ClientConnection> copy;
        Http1xPool http1xPool = this;
        synchronized (http1xPool) {
            copy = new HashSet<ClientConnection>(this.allConnections);
            this.allConnections.clear();
        }
        for (ClientConnection conn : copy) {
            try {
                conn.close();
            }
            catch (Throwable t) {
                ConnectionManager.log.error((Object)"Failed to close connection", t);
            }
        }
    }

    void removeChannel(Channel channel) {
        this.connectionMap.remove(channel);
    }
}

