/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.ext.hawkular.AuthenticationOptions;
import io.vertx.ext.hawkular.MetricsType;
import io.vertx.ext.hawkular.VertxHawkularOptionsConverter;
import java.util.EnumSet;
import java.util.Set;

@DataObject(generateConverter=true, inheritConverter=true)
public class VertxHawkularOptions
extends MetricsOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_METRICS_URI = "/hawkular/metrics";
    public static final String DEFAULT_TENANT = "default";
    public static final int DEFAULT_SCHEDULE = 1;
    public static final String DEFAULT_PREFIX = "";
    public static final int DEFAULT_BATCH_SIZE = 50;
    public static final int DEFAULT_BATCH_DELAY = 1;
    public static final String DEFAULT_METRICS_BRIDGE_ADDRESS = "hawkular.metrics";
    public static final boolean DEFAULT_METRICS_BRIDGE_ENABLED = false;
    private String host;
    private int port;
    private HttpClientOptions httpOptions;
    private String metricsServiceUri;
    private String tenant;
    private boolean sendTenantHeader;
    private AuthenticationOptions authenticationOptions;
    private JsonObject httpHeaders;
    private int schedule;
    private String prefix;
    private int batchSize;
    private int batchDelay;
    private boolean metricsBridgeEnabled;
    private String metricsBridgeAddress;
    private Set<MetricsType> disabledMetricsTypes;

    public VertxHawkularOptions() {
        this.host = DEFAULT_HOST;
        this.port = 8080;
        this.httpOptions = new HttpClientOptions();
        this.metricsServiceUri = DEFAULT_METRICS_URI;
        this.tenant = DEFAULT_TENANT;
        this.sendTenantHeader = true;
        this.authenticationOptions = new AuthenticationOptions();
        this.httpHeaders = new JsonObject();
        this.schedule = 1;
        this.prefix = DEFAULT_PREFIX;
        this.batchSize = 50;
        this.batchDelay = 1;
        this.metricsBridgeEnabled = false;
        this.metricsBridgeAddress = DEFAULT_METRICS_BRIDGE_ADDRESS;
        this.disabledMetricsTypes = EnumSet.noneOf(MetricsType.class);
    }

    public VertxHawkularOptions(VertxHawkularOptions other) {
        super(other);
        this.host = other.host;
        this.port = other.port;
        this.httpOptions = other.httpOptions != null ? new HttpClientOptions(other.httpOptions) : new HttpClientOptions();
        this.metricsServiceUri = other.metricsServiceUri;
        this.tenant = other.tenant;
        this.sendTenantHeader = other.sendTenantHeader;
        this.authenticationOptions = other.authenticationOptions != null ? new AuthenticationOptions(other.authenticationOptions) : new AuthenticationOptions();
        this.httpHeaders = other.httpHeaders;
        this.schedule = other.schedule;
        this.prefix = other.prefix;
        this.batchSize = other.batchSize;
        this.batchDelay = other.batchDelay;
        this.metricsBridgeAddress = other.metricsBridgeAddress;
        this.metricsBridgeEnabled = other.metricsBridgeEnabled;
        this.disabledMetricsTypes = other.disabledMetricsTypes != null ? EnumSet.copyOf(other.disabledMetricsTypes) : EnumSet.noneOf(MetricsType.class);
    }

    public VertxHawkularOptions(JsonObject json) {
        this();
        VertxHawkularOptionsConverter.fromJson(json, this);
    }

    public String getHost() {
        return this.host;
    }

    public VertxHawkularOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public VertxHawkularOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public HttpClientOptions getHttpOptions() {
        return this.httpOptions;
    }

    public VertxHawkularOptions setHttpOptions(HttpClientOptions httpOptions) {
        this.httpOptions = httpOptions;
        return this;
    }

    public String getMetricsServiceUri() {
        return this.metricsServiceUri;
    }

    public VertxHawkularOptions setMetricsServiceUri(String metricsServiceUri) {
        this.metricsServiceUri = metricsServiceUri;
        return this;
    }

    public String getTenant() {
        return this.tenant;
    }

    public VertxHawkularOptions setTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public boolean isSendTenantHeader() {
        return this.sendTenantHeader;
    }

    public VertxHawkularOptions setSendTenantHeader(boolean sendTenantHeader) {
        this.sendTenantHeader = sendTenantHeader;
        return this;
    }

    public AuthenticationOptions getAuthenticationOptions() {
        return this.authenticationOptions;
    }

    public VertxHawkularOptions setAuthenticationOptions(AuthenticationOptions authenticationOptions) {
        this.authenticationOptions = authenticationOptions;
        return this;
    }

    public JsonObject getHttpHeaders() {
        return this.httpHeaders;
    }

    public VertxHawkularOptions setHttpHeaders(JsonObject httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public int getSchedule() {
        return this.schedule;
    }

    public VertxHawkularOptions setSchedule(int schedule) {
        this.schedule = schedule;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public VertxHawkularOptions setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public VertxHawkularOptions setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getBatchDelay() {
        return this.batchDelay;
    }

    public VertxHawkularOptions setBatchDelay(int batchDelay) {
        this.batchDelay = batchDelay;
        return this;
    }

    @Override
    public VertxHawkularOptions setEnabled(boolean enable) {
        super.setEnabled(enable);
        return this;
    }

    public String getMetricsBridgeAddress() {
        return this.metricsBridgeAddress;
    }

    public VertxHawkularOptions setMetricsBridgeAddress(String metricsBridgeAddress) {
        this.metricsBridgeAddress = metricsBridgeAddress;
        return this;
    }

    public boolean isMetricsBridgeEnabled() {
        return this.metricsBridgeEnabled;
    }

    public VertxHawkularOptions setMetricsBridgeEnabled(boolean metricsBridgeEnabled) {
        this.metricsBridgeEnabled = metricsBridgeEnabled;
        return this;
    }

    public Set<MetricsType> getDisabledMetricsTypes() {
        return this.disabledMetricsTypes;
    }

    public void setDisabledMetricsTypes(Set<MetricsType> disabledMetricsTypes) {
        this.disabledMetricsTypes = disabledMetricsTypes;
    }

    public VertxHawkularOptions addDisabledMetricsType(MetricsType metricsType) {
        this.disabledMetricsTypes.add(metricsType);
        return this;
    }

    public boolean isMetricsTypeDisabled(MetricsType metricsType) {
        return this.disabledMetricsTypes.contains((Object)metricsType);
    }
}

