/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class HandlersMeasurements {
    private final LongAdder processingTime;
    private final int handlersCount;

    public HandlersMeasurements() {
        this.processingTime = new LongAdder();
        this.handlersCount = 1;
    }

    private HandlersMeasurements(LongAdder processingTime, int handlersCount) {
        this.processingTime = processingTime;
        this.handlersCount = handlersCount;
    }

    public void addProcessingTime(long time) {
        this.processingTime.add(time);
    }

    public long processingTime() {
        return TimeUnit.MILLISECONDS.convert(this.processingTime.sum(), TimeUnit.NANOSECONDS);
    }

    public int handlersCount() {
        return this.handlersCount;
    }

    public HandlersMeasurements incrementHandlersCount() {
        return new HandlersMeasurements(this.processingTime, this.handlersCount + 1);
    }

    public HandlersMeasurements decrementHandlersCount() {
        return new HandlersMeasurements(this.processingTime, this.handlersCount - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandlersMeasurements that = (HandlersMeasurements)o;
        return this.handlersCount == that.handlersCount;
    }

    public int hashCode() {
        return this.handlersCount;
    }
}

