/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.ext.hawkular.impl.HttpServerMetricsSupplier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class HttpServerMetricsImpl
implements HttpServerMetrics<Long, Void, Void> {
    private final LongAdder processingTime = new LongAdder();
    private final LongAdder requestCount = new LongAdder();
    private final LongAdder requests = new LongAdder();
    private final LongAdder httpConnections = new LongAdder();
    private final LongAdder wsConnections = new LongAdder();
    private final LongAdder bytesReceived = new LongAdder();
    private final LongAdder bytesSent = new LongAdder();
    private final LongAdder errorCount = new LongAdder();
    private final SocketAddress localAddress;
    private final HttpServerMetricsSupplier httpServerMetricsSupplier;

    public HttpServerMetricsImpl(SocketAddress localAddress, HttpServerMetricsSupplier httpServerMetricsSupplier) {
        this.localAddress = localAddress;
        this.httpServerMetricsSupplier = httpServerMetricsSupplier;
        httpServerMetricsSupplier.register(this);
    }

    @Override
    public Long requestBegin(Void socketMetric, HttpServerRequest request) {
        this.requests.increment();
        return System.nanoTime();
    }

    @Override
    public void requestReset(Long requestMetric) {
        this.requestCount.increment();
        this.requests.decrement();
    }

    @Override
    public Long responsePushed(Void socketMetric, HttpMethod method, String uri, HttpServerResponse response) {
        this.requests.increment();
        return System.nanoTime();
    }

    @Override
    public void responseEnd(Long nanoStart, HttpServerResponse response) {
        long requestProcessingTime = System.nanoTime() - nanoStart;
        this.processingTime.add(requestProcessingTime);
        this.requestCount.increment();
        this.requests.decrement();
    }

    @Override
    public Void upgrade(Long requestMetric, ServerWebSocket serverWebSocket) {
        return null;
    }

    @Override
    public Void connected(Void socketMetric, ServerWebSocket serverWebSocket) {
        this.wsConnections.increment();
        return null;
    }

    @Override
    public void disconnected(Void serverWebSocketMetric) {
        this.wsConnections.decrement();
    }

    @Override
    public Void connected(SocketAddress remoteAddress, String remoteName) {
        this.httpConnections.increment();
        return null;
    }

    @Override
    public void disconnected(Void socketMetric, SocketAddress remoteAddress) {
        this.httpConnections.decrement();
    }

    @Override
    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesReceived.add(numberOfBytes);
    }

    @Override
    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesSent.add(numberOfBytes);
    }

    @Override
    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.errorCount.increment();
    }

    public SocketAddress getServerAddress() {
        return this.localAddress;
    }

    public Long getProcessingTime() {
        return TimeUnit.MILLISECONDS.convert(this.processingTime.sum(), TimeUnit.NANOSECONDS);
    }

    public Long getRequestCount() {
        return this.requestCount.sum();
    }

    public Long getRequests() {
        return this.requests.sum();
    }

    public Long getHttpConnections() {
        return this.httpConnections.sum();
    }

    public Long getWsConnections() {
        return this.wsConnections.sum();
    }

    public Long getBytesReceived() {
        return this.bytesReceived.sum();
    }

    public Long getBytesSent() {
        return this.bytesSent.sum();
    }

    public Long getErrorCount() {
        return this.errorCount.sum();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
        this.httpServerMetricsSupplier.unregister(this);
    }
}

