/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.hawkular.impl;

import java.util.concurrent.atomic.LongAdder;

public class NetClientConnectionsMeasurements {
    private final LongAdder connections = new LongAdder();
    private final LongAdder bytesReceived = new LongAdder();
    private final LongAdder bytesSent = new LongAdder();
    private final LongAdder errorCount = new LongAdder();

    public void incrementConnections() {
        this.connections.increment();
    }

    public void decrementConnections() {
        this.connections.decrement();
    }

    public void addBytesReceived(long numberOfBytes) {
        this.bytesReceived.add(numberOfBytes);
    }

    public void addBytesSent(long numberOfBytes) {
        this.bytesSent.add(numberOfBytes);
    }

    public void incrementErrorCount() {
        this.errorCount.increment();
    }

    public Snapshot getSnapshot() {
        return new Snapshot(this.connections.sum(), this.bytesReceived.sum(), this.bytesSent.sum(), this.errorCount.sum());
    }

    public static class Snapshot {
        private final long connections;
        private final long bytesReceived;
        private final long bytesSent;
        private final long errorCount;

        private Snapshot(long connections, long bytesReceived, long bytesSent, long errorCount) {
            this.connections = connections;
            this.bytesReceived = bytesReceived;
            this.bytesSent = bytesSent;
            this.errorCount = errorCount;
        }

        public long getConnections() {
            return this.connections;
        }

        public long getBytesReceived() {
            return this.bytesReceived;
        }

        public long getBytesSent() {
            return this.bytesSent;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public static Snapshot merge(Snapshot s1, Snapshot s2) {
            return new Snapshot(s1.connections + s2.connections, s1.bytesReceived + s2.bytesReceived, s1.bytesSent + s2.bytesSent, s1.errorCount + s2.errorCount);
        }
    }
}

