/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans;

import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.hawkular.metrics.clients.ptrans.ConfigurationKey;
import org.hawkular.metrics.clients.ptrans.Service;

public class Configuration {
    private final Set<Service> services;
    private final int udpPort;
    private final int tcpPort;
    private final int gangliaPort;
    private final String gangliaGroup;
    private final int statsDport;
    private final int collectdPort;
    private final int graphitePort;
    private final String multicastIfOverride;
    private final int minimumBatchSize;
    private final int maximumBatchDelay;
    private final URI restUrl;
    private final URI httpProxy;
    private final String tenant;
    private final int restCloseAfterRequests;
    private final int spoolSize;
    private final Set<String> validationMessages;

    private Configuration(Set<Service> services, int udpPort, int tcpPort, int gangliaPort, String gangliaGroup, int statsDport, int collectdPort, int graphitePort, String multicastIfOverride, int minimumBatchSize, int maximumBatchDelay, URI restUrl, URI httpProxy, String tenant, int restCloseAfterRequests, int spoolSize, Set<String> validationMessages) {
        this.services = services;
        this.udpPort = udpPort;
        this.tcpPort = tcpPort;
        this.gangliaPort = gangliaPort;
        this.statsDport = statsDport;
        this.collectdPort = collectdPort;
        this.gangliaGroup = gangliaGroup;
        this.graphitePort = graphitePort;
        this.multicastIfOverride = multicastIfOverride;
        this.minimumBatchSize = minimumBatchSize;
        this.maximumBatchDelay = maximumBatchDelay;
        this.restUrl = restUrl;
        this.httpProxy = httpProxy;
        this.tenant = tenant;
        this.restCloseAfterRequests = restCloseAfterRequests;
        this.spoolSize = spoolSize;
        this.validationMessages = Collections.unmodifiableSet(validationMessages);
    }

    public static Configuration from(Properties properties) {
        HashSet<String> validationMessages = new HashSet<String>();
        Set<Service> services = Configuration.getServices(properties, validationMessages);
        int udpPort = Configuration.getIntProperty(properties, ConfigurationKey.UDP_PORT, 5140);
        int tcpPort = Configuration.getIntProperty(properties, ConfigurationKey.TCP_PORT, 5140);
        int gangliaPort = Configuration.getIntProperty(properties, ConfigurationKey.GANGLIA_PORT, 8649);
        String gangliaGroup = properties.getProperty(ConfigurationKey.GANGLIA_GROUP.toString(), "239.2.11.71");
        String multicastIfOverride = properties.getProperty(ConfigurationKey.GANGLIA_MULTICAST_INTERFACE.toString());
        int statsDport = Configuration.getIntProperty(properties, ConfigurationKey.STATSD_PORT, 8125);
        int collectdPort = Configuration.getIntProperty(properties, ConfigurationKey.COLLECTD_PORT, 25826);
        int graphitePort = Configuration.getIntProperty(properties, ConfigurationKey.GRAPHITE_PORT, 2003);
        int minimumBatchSize = Configuration.getIntProperty(properties, ConfigurationKey.BATCH_SIZE, 50);
        int maximumBatchDelay = Configuration.getIntProperty(properties, ConfigurationKey.BATCH_DELAY, 1);
        URI restUrl = URI.create(properties.getProperty(ConfigurationKey.REST_URL.toString(), "http://localhost:8080/hawkular/metrics/gauges/data"));
        String proxyString = properties.getProperty(ConfigurationKey.HTTP_PROXY.toString());
        URI httpProxy = null;
        if (proxyString != null && !proxyString.trim().isEmpty()) {
            httpProxy = URI.create(proxyString);
        }
        String tenant = properties.getProperty(ConfigurationKey.TENANT.toString(), "default");
        int restCloseAfterRequests = Configuration.getIntProperty(properties, ConfigurationKey.REST_CLOSE_AFTER_REQUESTS, 200);
        int spoolSize = Configuration.getIntProperty(properties, ConfigurationKey.SPOOL_SIZE, 10000);
        return new Configuration(services, udpPort, tcpPort, gangliaPort, gangliaGroup, statsDport, collectdPort, graphitePort, multicastIfOverride, minimumBatchSize, maximumBatchDelay, restUrl, httpProxy, tenant, restCloseAfterRequests, spoolSize, validationMessages);
    }

    private static Set<Service> getServices(Properties properties, Set<String> validationMessages) {
        String servicesProperty = properties.getProperty(ConfigurationKey.SERVICES.toString());
        if (servicesProperty == null) {
            validationMessages.add(String.format(Locale.ROOT, "Property %s not found", ConfigurationKey.SERVICES.toString()));
            return Collections.emptySet();
        }
        EnumSet<Service> services = EnumSet.noneOf(Service.class);
        StringTokenizer tokenizer = new StringTokenizer(servicesProperty, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.isEmpty()) continue;
            Service service = Service.findByExternalForm(token);
            if (service == null) {
                validationMessages.add(String.format(Locale.ROOT, "Unknown service %s", token));
                continue;
            }
            services.add(service);
        }
        if (services.isEmpty()) {
            validationMessages.add("Empty services list");
        }
        return services;
    }

    private static int getIntProperty(Properties properties, ConfigurationKey key, int defaultValue) {
        String property = properties.getProperty(key.toString());
        if (property == null) {
            return defaultValue;
        }
        return Integer.parseInt(property);
    }

    public boolean isValid() {
        return this.validationMessages.isEmpty();
    }

    public Set<String> getValidationMessages() {
        return this.validationMessages;
    }

    public Set<Service> getServices() {
        return this.services;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int getGangliaPort() {
        return this.gangliaPort;
    }

    public int getStatsDport() {
        return this.statsDport;
    }

    public int getCollectdPort() {
        return this.collectdPort;
    }

    public int getGraphitePort() {
        return this.graphitePort;
    }

    public String getGangliaGroup() {
        return this.gangliaGroup;
    }

    public String getMulticastIfOverride() {
        return this.multicastIfOverride;
    }

    public int getMinimumBatchSize() {
        return this.minimumBatchSize;
    }

    public int getMaximumBatchDelay() {
        return this.maximumBatchDelay;
    }

    public URI getRestUrl() {
        return this.restUrl;
    }

    public URI getHttpProxy() {
        return this.httpProxy;
    }

    public String getTenant() {
        return this.tenant;
    }

    public int getRestCloseAfterRequests() {
        return this.restCloseAfterRequests;
    }

    public int getSpoolSize() {
        return this.spoolSize;
    }
}

