/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.List;
import org.hawkular.metrics.client.common.SingleMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricBatcher
extends MessageToMessageDecoder<SingleMetric> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricBatcher.class);
    private final int minimumBatchSize;
    private final AttributeKey<List<SingleMetric>> cacheKey;

    public MetricBatcher(String subKey, int minimumBatchSize) {
        this.minimumBatchSize = Math.max(1, minimumBatchSize);
        this.cacheKey = AttributeKey.valueOf("cachedMetrics." + subKey);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, SingleMetric msg, List<Object> out) throws Exception {
        LOG.trace("Incoming metric for key '{}'", (Object)this.cacheKey.name());
        Attribute<List<SingleMetric>> cache = ctx.attr(this.cacheKey);
        List<SingleMetric> batchList = cache.get();
        if (batchList == null) {
            LOG.trace("Creating new batch list for key '{}'", (Object)this.cacheKey.name());
            batchList = new ArrayList<SingleMetric>(this.minimumBatchSize);
            cache.set(batchList);
        }
        batchList.add(msg);
        if (batchList.size() >= this.minimumBatchSize) {
            LOG.trace("Batch size limit '{}' reached for key '{}'", (Object)this.minimumBatchSize, (Object)this.cacheKey.name());
            cache.remove();
            out.add(batchList);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!(evt instanceof IdleStateEvent)) {
            LOG.trace("Dropping unhandled event '{}' for key '{}'", evt, (Object)this.cacheKey.name());
            return;
        }
        IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
        if (idleStateEvent != IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT) {
            LOG.trace("Dropping event, expecting FIRST_READER_IDLE_STATE_EVENT for key '{}'", (Object)this.cacheKey.name());
            return;
        }
        List<SingleMetric> batchList = ctx.attr(this.cacheKey).getAndRemove();
        if (batchList != null && !batchList.isEmpty()) {
            LOG.trace("Batch delay reached for key '{}', forwarding {} metrics", (Object)this.cacheKey.name(), (Object)batchList.size());
            ctx.fireChannelRead(batchList);
        }
    }
}

