/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.metrics.clients.ptrans.Configuration;
import org.hawkular.metrics.clients.ptrans.Service;
import org.hawkular.metrics.clients.ptrans.backend.RestForwardingHandler;
import org.hawkular.metrics.clients.ptrans.collectd.CollectdChannelInitializer;
import org.hawkular.metrics.clients.ptrans.ganglia.GangliaChannelInitializer;
import org.hawkular.metrics.clients.ptrans.graphite.GraphiteChannelInitializer;
import org.hawkular.metrics.clients.ptrans.statsd.StatsdChannelInitializer;
import org.hawkular.metrics.clients.ptrans.syslog.TcpChannelInitializer;
import org.hawkular.metrics.clients.ptrans.syslog.UdpChannelInitializer;
import org.hawkular.metrics.clients.ptrans.util.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTrans {
    private static final Logger LOG = LoggerFactory.getLogger(PTrans.class);
    private final Configuration configuration;
    private final EventLoopGroup group;
    private final EventLoopGroup workerGroup;
    private final RestForwardingHandler forwardingHandler;

    public PTrans(Configuration configuration) {
        Arguments.checkArgument(configuration != null, "Configuration is null", new Object[0]);
        Arguments.checkArgument(configuration.isValid(), configuration.getValidationMessages().stream().collect(Collectors.joining(", ")), new Object[0]);
        this.configuration = configuration;
        this.group = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.forwardingHandler = new RestForwardingHandler(configuration);
    }

    public void start() {
        LOG.info("Starting ptrans...");
        Set<Service> services = this.configuration.getServices();
        ArrayList<ChannelFuture> closeFutures = new ArrayList<ChannelFuture>(services.size());
        if (services.contains((Object)Service.TCP)) {
            ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.group, this.workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.configuration.getTcpPort())).childHandler(new TcpChannelInitializer(this.forwardingHandler));
            ChannelFuture tcpBindFuture = serverBootstrap.bind().syncUninterruptibly();
            LOG.info("Server listening on TCP {}", (Object)tcpBindFuture.channel().localAddress());
            closeFutures.add(tcpBindFuture.channel().closeFuture());
        }
        if (services.contains((Object)Service.UDP)) {
            Bootstrap udpBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioDatagramChannel.class)).localAddress(this.configuration.getUdpPort())).handler(new UdpChannelInitializer(this.forwardingHandler));
            ChannelFuture udpBindFuture = udpBootstrap.bind().syncUninterruptibly();
            LOG.info("Syslogd listening on UDP {}", (Object)udpBindFuture.channel().localAddress());
            closeFutures.add(udpBindFuture.channel().closeFuture());
        }
        if (services.contains((Object)Service.GANGLIA)) {
            NetworkInterface mcIf;
            try {
                String multicastIfOverride = this.configuration.getMulticastIfOverride();
                if (multicastIfOverride == null) {
                    Inet4Address hostAddr = (Inet4Address)InetAddress.getLocalHost();
                    mcIf = NetworkInterface.getByInetAddress(hostAddr);
                } else {
                    mcIf = NetworkInterface.getByName(multicastIfOverride);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            InetSocketAddress gangliaSocket = new InetSocketAddress(this.configuration.getGangliaGroup(), this.configuration.getGangliaPort());
            Bootstrap gangliaBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.IP_MULTICAST_IF, mcIf)).localAddress(gangliaSocket)).handler(new GangliaChannelInitializer(this.configuration, this.forwardingHandler));
            LOG.trace("Ganglia bootstrap is {}", (Object)gangliaBootstrap);
            ChannelFuture gangliaBindFuture = gangliaBootstrap.bind().syncUninterruptibly();
            LOG.info("Ganglia listening on UDP {}", (Object)gangliaBindFuture.channel().localAddress());
            DatagramChannel gangliaChannel = (DatagramChannel)gangliaBindFuture.channel();
            gangliaChannel.joinGroup(gangliaSocket, mcIf);
            LOG.trace("Joined the Ganglia group");
            closeFutures.add(gangliaChannel.closeFuture());
        }
        if (services.contains((Object)Service.STATSD)) {
            Bootstrap statsdBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioDatagramChannel.class)).localAddress(this.configuration.getStatsDport())).handler(new StatsdChannelInitializer(this.configuration, this.forwardingHandler));
            ChannelFuture statsdBindFuture = statsdBootstrap.bind().syncUninterruptibly();
            LOG.info("Statsd listening on UDP {}", (Object)statsdBindFuture.channel().localAddress());
            closeFutures.add(statsdBindFuture.channel().closeFuture());
        }
        if (services.contains((Object)Service.GRAPHITE)) {
            ServerBootstrap graphiteBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.group).channel(NioServerSocketChannel.class)).localAddress(this.configuration.getGraphitePort())).childHandler(new GraphiteChannelInitializer(this.forwardingHandler));
            ChannelFuture graphiteBindFuture = graphiteBootstrap.bind().syncUninterruptibly();
            LOG.info("Graphite listening on TCP {}", (Object)graphiteBindFuture.channel().localAddress());
            closeFutures.add(graphiteBindFuture.channel().closeFuture());
        }
        if (services.contains((Object)Service.COLLECTD)) {
            Bootstrap collectdBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioDatagramChannel.class)).localAddress(this.configuration.getCollectdPort())).handler(new CollectdChannelInitializer(this.configuration, this.forwardingHandler));
            ChannelFuture collectdBindFuture = collectdBootstrap.bind().syncUninterruptibly();
            LOG.info("Collectd listening on UDP {}", (Object)collectdBindFuture.channel().localAddress());
            closeFutures.add(collectdBindFuture.channel().closeFuture());
        }
        LOG.info("ptrans started");
        closeFutures.forEach(ChannelFuture::syncUninterruptibly);
    }

    public void stop() {
        LOG.info("Stopping ptrans...");
        this.group.shutdownGracefully().syncUninterruptibly();
        this.workerGroup.shutdownGracefully().syncUninterruptibly();
        LOG.info("ptrans stopped");
    }
}

