/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import java.util.ListIterator;
import org.hawkular.metrics.client.common.SingleMetric;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeResolution;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeSpan;
import org.hawkular.metrics.clients.ptrans.collectd.event.ValueListEvent;

@ChannelHandler.Sharable
public class CollectdEventHandler
extends MessageToMessageDecoder<ValueListEvent> {
    @Override
    protected void decode(ChannelHandlerContext ctx, ValueListEvent event, List<Object> out) throws Exception {
        StringBuilder prefixBuilder = new StringBuilder("collectd.").append(event.getHost()).append(".").append(event.getPluginName());
        String pluginInstance = event.getPluginInstance();
        if (pluginInstance != null && pluginInstance.length() > 0) {
            prefixBuilder.append(".").append(pluginInstance);
        }
        prefixBuilder.append(".").append(event.getTypeName());
        String typeInstance = event.getTypeInstance();
        if (typeInstance != null && typeInstance.length() > 0) {
            prefixBuilder.append(".").append(typeInstance);
        }
        String prefix = prefixBuilder.toString();
        TimeSpan timeSpan = event.getTimestamp();
        List<Number> values = event.getValues();
        ListIterator<Number> iterator = values.listIterator();
        while (iterator.hasNext()) {
            Number value = iterator.next();
            long timestamp = TimeResolution.toMillis(timeSpan);
            StringBuilder sourceBuilder = new StringBuilder(prefix);
            if (values.size() > 1) {
                sourceBuilder.append(".").append(iterator.previousIndex());
            }
            SingleMetric singleMetric = new SingleMetric(sourceBuilder.toString(), timestamp, value.doubleValue());
            out.add(singleMetric);
        }
    }
}

