/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd.event;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeResolution;
import org.hawkular.metrics.clients.ptrans.collectd.event.TimeSpan;
import org.hawkular.metrics.clients.ptrans.collectd.event.ValueListEvent;
import org.hawkular.metrics.clients.ptrans.collectd.packet.CollectdPacket;
import org.hawkular.metrics.clients.ptrans.collectd.packet.NumericPart;
import org.hawkular.metrics.clients.ptrans.collectd.packet.Part;
import org.hawkular.metrics.clients.ptrans.collectd.packet.PartType;
import org.hawkular.metrics.clients.ptrans.collectd.packet.StringPart;
import org.hawkular.metrics.clients.ptrans.collectd.packet.ValuePart;
import org.hawkular.metrics.clients.ptrans.collectd.packet.Values;

@ChannelHandler.Sharable
public final class CollectdEventsDecoder
extends MessageToMessageDecoder<CollectdPacket> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CollectdEventsDecoder.class);
    private static final String EMPTY_STRING_VALUE = "";

    @Override
    protected void decode(ChannelHandlerContext context, CollectdPacket packet, List<Object> out) throws Exception {
        long start = System.currentTimeMillis();
        String host = EMPTY_STRING_VALUE;
        String pluginName = EMPTY_STRING_VALUE;
        String pluginInstance = EMPTY_STRING_VALUE;
        String typeName = EMPTY_STRING_VALUE;
        String typeInstance = EMPTY_STRING_VALUE;
        TimeSpan timestamp = null;
        TimeSpan interval = null;
        ArrayList<ValueListEvent> events = new ArrayList<ValueListEvent>(50);
        block12: for (Part part : packet.getParts()) {
            PartType partType = part.getPartType();
            switch (partType) {
                case HOST: {
                    host = this.getString(part);
                    continue block12;
                }
                case PLUGIN: {
                    pluginName = this.getString(part);
                    continue block12;
                }
                case PLUGIN_INSTANCE: {
                    pluginInstance = this.getString(part);
                    continue block12;
                }
                case TYPE: {
                    typeName = this.getString(part);
                    continue block12;
                }
                case INSTANCE: {
                    typeInstance = this.getString(part);
                    continue block12;
                }
                case TIME: {
                    timestamp = new TimeSpan(this.getLong(part), TimeResolution.SECONDS);
                    continue block12;
                }
                case TIME_HIGH_RESOLUTION: {
                    timestamp = new TimeSpan(this.getLong(part), TimeResolution.HIGH_RES);
                    continue block12;
                }
                case INTERVAL: {
                    interval = new TimeSpan(this.getLong(part), TimeResolution.SECONDS);
                    continue block12;
                }
                case INTERVAL_HIGH_RESOLUTION: {
                    interval = new TimeSpan(this.getLong(part), TimeResolution.HIGH_RES);
                    continue block12;
                }
                case VALUES: {
                    ValueListEvent event = new ValueListEvent(host, timestamp, pluginName, pluginInstance, typeName, typeInstance, this.getValues(part).getData(), interval);
                    logger.trace("Decoded ValueListEvent: {}", (Object)event);
                    events.add(event);
                    continue block12;
                }
            }
            logger.debug("Skipping unknown part type: {}", (Object)partType);
        }
        if (logger.isTraceEnabled()) {
            long stop = System.currentTimeMillis();
            logger.trace("Decoded events in {} ms", (Object)(stop - start));
        }
        out.addAll(events);
    }

    private String getString(Part part) {
        return (String)((StringPart)part).getValue();
    }

    private Long getLong(Part part) {
        return (Long)((NumericPart)part).getValue();
    }

    private Values getValues(Part part) {
        return (Values)((ValuePart)part).getValue();
    }
}

