/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.collectd.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.hawkular.metrics.clients.ptrans.collectd.event.DataType;
import org.hawkular.metrics.clients.ptrans.collectd.packet.CollectdPacket;
import org.hawkular.metrics.clients.ptrans.collectd.packet.NumericPart;
import org.hawkular.metrics.clients.ptrans.collectd.packet.Part;
import org.hawkular.metrics.clients.ptrans.collectd.packet.PartType;
import org.hawkular.metrics.clients.ptrans.collectd.packet.StringPart;
import org.hawkular.metrics.clients.ptrans.collectd.packet.ValuePart;
import org.hawkular.metrics.clients.ptrans.collectd.packet.Values;

@ChannelHandler.Sharable
public final class CollectdPacketDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CollectdPacketDecoder.class);

    @Override
    protected void decode(ChannelHandlerContext context, DatagramPacket packet, List<Object> out) throws Exception {
        long start = System.currentTimeMillis();
        ByteBuf content = (ByteBuf)packet.content();
        ArrayList<Part> parts = new ArrayList<Part>(100);
        while (this.hasReadableBytes(content, 4)) {
            Part part;
            short partTypeId = content.readShort();
            PartType partType = PartType.findById(partTypeId);
            int partLength = content.readUnsignedShort();
            int valueLength = partLength - 4;
            if (!this.hasReadableBytes(content, valueLength)) break;
            if (partType == null) {
                content.skipBytes(valueLength);
                continue;
            }
            switch (partType) {
                case HOST: 
                case PLUGIN: 
                case PLUGIN_INSTANCE: 
                case TYPE: 
                case INSTANCE: {
                    part = new StringPart(partType, this.readStringPartContent(content, valueLength));
                    break;
                }
                case TIME: 
                case TIME_HIGH_RESOLUTION: 
                case INTERVAL: 
                case INTERVAL_HIGH_RESOLUTION: {
                    part = new NumericPart(partType, this.readNumericPartContent(content));
                    break;
                }
                case VALUES: {
                    part = new ValuePart(partType, this.readValuePartContent(content, valueLength));
                    break;
                }
                default: {
                    part = null;
                    content.skipBytes(valueLength);
                }
            }
            if (part == null) continue;
            logger.trace("Decoded part: {}", (Object)part);
            parts.add(part);
        }
        if (logger.isTraceEnabled()) {
            long stop = System.currentTimeMillis();
            logger.trace("Decoded datagram in {} ms", (Object)(stop - start));
        }
        if (parts.size() > 0) {
            CollectdPacket collectdPacket = new CollectdPacket(parts);
            out.add(collectdPacket);
        } else {
            logger.debug("No parts decoded, no CollectdPacket output");
        }
    }

    private boolean hasReadableBytes(ByteBuf content, int count) {
        return content.readableBytes() >= count;
    }

    private String readStringPartContent(ByteBuf content, int length) {
        String string = content.toString(content.readerIndex(), length - 1, CharsetUtil.US_ASCII);
        content.skipBytes(length);
        return string;
    }

    private long readNumericPartContent(ByteBuf content) {
        return content.readLong();
    }

    private Values readValuePartContent(ByteBuf content, int length) {
        int beginIndex = content.readerIndex();
        int total = content.readUnsignedShort();
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(total);
        for (int i = 0; i < total; ++i) {
            byte sampleTypeId = content.readByte();
            dataTypes.add(DataType.findById(sampleTypeId));
        }
        ArrayList<Number> data = new ArrayList<Number>(total);
        block6: for (DataType dataType : dataTypes) {
            switch (dataType) {
                case COUNTER: 
                case ABSOLUTE: {
                    byte[] valueBytes = new byte[8];
                    content.readBytes(valueBytes);
                    data.add(new BigInteger(1, valueBytes));
                    continue block6;
                }
                case DERIVE: {
                    data.add(content.readLong());
                    continue block6;
                }
                case GAUGE: {
                    data.add(Double.longBitsToDouble(ByteBufUtil.swapLong(content.readLong())));
                    continue block6;
                }
            }
            logger.debug("Skipping unknown data type: {}", (Object)dataType);
        }
        int readCount = content.readerIndex() - beginIndex;
        if (length > readCount) {
            content.skipBytes(readCount - length);
        }
        return new Values(dataTypes, data);
    }
}

