/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.clients.ptrans.graphite;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.client.common.SingleMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteEventDecoder
extends MessageToMessageDecoder<String> {
    private static final Logger LOG = LoggerFactory.getLogger(GraphiteEventDecoder.class);

    @Override
    protected void decode(ChannelHandlerContext ctx, String msg, List<Object> out) throws Exception {
        String[] items = msg.split(" ");
        if (items.length != 3) {
            LOG.debug("Unknown data format for '{}', skipping", (Object)msg);
            return;
        }
        String name = items[0];
        double value = Double.parseDouble(items[1]);
        long timestamp = TimeUnit.MILLISECONDS.convert(Long.parseLong(items[2]), TimeUnit.SECONDS);
        SingleMetric metric = new SingleMetric(name, timestamp, value);
        out.add(Collections.singletonList(metric));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.debug("Could not decode message", cause);
        ctx.channel().close();
    }
}

