/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.blueprints;

import com.thinkaurelius.titan.BerkeleyStorageSetup;
import com.thinkaurelius.titan.blueprints.TitanBlueprintsTest;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.tinkerpop.blueprints.Graph;
import java.io.File;
import java.util.Map;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyBlueprintsTest
extends TitanBlueprintsTest {
    private static final String DEFAULT_SUBDIR = "standard";
    private static final Logger log = LoggerFactory.getLogger(BerkeleyBlueprintsTest.class);

    public Graph generateGraph() {
        return this.generateGraph(DEFAULT_SUBDIR);
    }

    public void beforeOpeningGraph(String uid) {
        String dir = BerkeleyStorageSetup.getHomeDir((String)uid);
        log.debug("Cleaning directory {} before opening it for the first time", (Object)dir);
        try {
            BerkeleyJEStoreManager s = new BerkeleyJEStoreManager((Configuration)BerkeleyStorageSetup.getBerkeleyJEConfiguration(dir));
            s.clearStorage();
            s.close();
            File dirFile = new File(dir);
            Assert.assertFalse((dirFile.exists() && dirFile.listFiles().length > 0 ? 1 : 0) != 0);
        }
        catch (BackendException e) {
            throw new RuntimeException(e);
        }
    }

    public TitanGraph openGraph(String uid) {
        String dir = BerkeleyStorageSetup.getHomeDir((String)uid);
        return TitanFactory.open((BasicConfiguration)BerkeleyStorageSetup.getBerkeleyJEConfiguration(dir));
    }

    public void extraCleanUp(String uid) throws BackendException {
        String dir = BerkeleyStorageSetup.getHomeDir((String)uid);
        BerkeleyJEStoreManager s = new BerkeleyJEStoreManager((Configuration)BerkeleyStorageSetup.getBerkeleyJEConfiguration(dir));
        s.clearStorage();
        s.close();
        File dirFile = new File(dir);
        Assert.assertFalse((dirFile.exists() && dirFile.listFiles().length > 0 ? 1 : 0) != 0);
    }

    public boolean supportsMultipleGraphs() {
        return true;
    }

    public void beforeSuite() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSuite() {
        Map map = this.openGraphs;
        synchronized (map) {
            for (String dir : this.openGraphs.keySet()) {
                File dirFile = new File(dir);
                Assert.assertFalse((dirFile.exists() && dirFile.listFiles().length > 0 ? 1 : 0) != 0);
            }
        }
    }
}

