/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.berkeleyje;

import com.google.common.base.Preconditions;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEKeyValueStore;
import com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJETx;
import com.thinkaurelius.titan.diskstorage.common.LocalStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.MergedConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StandardStoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class BerkeleyJEStoreManager
extends LocalStoreManager
implements OrderedKeyValueStoreManager {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyJEStoreManager.class);
    public static final ConfigNamespace BERKELEY_NS = new ConfigNamespace(GraphDatabaseConfiguration.STORAGE_NS, "berkeleydb", "BerkeleyDB configuration options");
    public static final ConfigOption<Integer> JVM_CACHE = new ConfigOption(BERKELEY_NS, "cache-percentage", "Percentage of JVM heap reserved for BerkeleyJE's cache", ConfigOption.Type.MASKABLE, (Object)65, ConfigOption.positiveInt());
    public static final ConfigOption<LockMode> LOCK_MODE = new ConfigOption(BERKELEY_NS, "lock-mode", "The BDB record lock mode used for read operations", ConfigOption.Type.MASKABLE, LockMode.class, (Object)LockMode.DEFAULT, ConfigOption.disallowEmpty(LockMode.class));
    public static final ConfigOption<IsolationLevel> ISOLATION_LEVEL = new ConfigOption(BERKELEY_NS, "isolation-level", "The isolation level used by transactions", ConfigOption.Type.MASKABLE, IsolationLevel.class, (Object)IsolationLevel.REPEATABLE_READ, ConfigOption.disallowEmpty(IsolationLevel.class));
    private final Map<String, BerkeleyJEKeyValueStore> stores = new HashMap<String, BerkeleyJEKeyValueStore>();
    protected Environment environment;
    protected final StoreFeatures features;

    public BerkeleyJEStoreManager(Configuration configuration) throws BackendException {
        super(configuration);
        int cachePercentage = (Integer)configuration.get(JVM_CACHE, new String[0]);
        this.initialize(cachePercentage);
        this.features = new StandardStoreFeatures.Builder().orderedScan(true).transactional(this.transactional).keyConsistent((Configuration)GraphDatabaseConfiguration.buildConfiguration()).locking(true).keyOrdered(true).build();
    }

    private void initialize(int cachePercent) throws BackendException {
        try {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(this.transactional);
            envConfig.setCachePercent(cachePercent);
            if (this.batchLoading) {
                envConfig.setConfigParam("je.env.runCheckpointer", "false");
                envConfig.setConfigParam("je.env.runCleaner", "false");
            }
            this.environment = new Environment(this.directory, envConfig);
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException("Error during BerkeleyJE initialization: ", (Throwable)e);
        }
    }

    public StoreFeatures getFeatures() {
        return this.features;
    }

    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        throw new UnsupportedOperationException();
    }

    public BerkeleyJETx beginTransaction(BaseTransactionConfig txCfg) throws BackendException {
        try {
            Transaction tx = null;
            MergedConfiguration effectiveCfg = new MergedConfiguration(txCfg.getCustomOptions(), this.getStorageConfig());
            if (this.transactional) {
                TransactionConfig txnConfig = new TransactionConfig();
                ((IsolationLevel)((Object)effectiveCfg.get(ISOLATION_LEVEL, new String[0]))).configure(txnConfig);
                tx = this.environment.beginTransaction(null, txnConfig);
            }
            BerkeleyJETx btx = new BerkeleyJETx(tx, (LockMode)effectiveCfg.get(LOCK_MODE, new String[0]), txCfg);
            if (log.isTraceEnabled()) {
                log.trace("Berkeley tx created", (Throwable)new TransactionBegin(btx.toString()));
            }
            return btx;
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException("Could not start BerkeleyJE transaction", (Throwable)e);
        }
    }

    public BerkeleyJEKeyValueStore openDatabase(String name) throws BackendException {
        Preconditions.checkNotNull((Object)name);
        if (this.stores.containsKey(name)) {
            BerkeleyJEKeyValueStore store = this.stores.get(name);
            return store;
        }
        try {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(this.isReadOnly);
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(this.transactional);
            dbConfig.setKeyPrefixing(true);
            if (this.batchLoading) {
                dbConfig.setDeferredWrite(true);
            }
            Database db = this.environment.openDatabase(null, name, dbConfig);
            log.debug("Opened database {}", (Object)name, (Object)new Throwable());
            BerkeleyJEKeyValueStore store = new BerkeleyJEKeyValueStore(name, db, this);
            this.stores.put(name, store);
            return store;
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException("Could not open BerkeleyJE data store", (Throwable)e);
        }
    }

    public void mutateMany(Map<String, KVMutation> mutations, StoreTransaction txh) throws BackendException {
        for (Map.Entry<String, KVMutation> muts : mutations.entrySet()) {
            BerkeleyJEKeyValueStore store = this.openDatabase(muts.getKey());
            KVMutation mut = muts.getValue();
            if (!mut.hasAdditions() && !mut.hasDeletions()) {
                log.debug("Empty mutation set for {}, doing nothing", (Object)muts.getKey());
            } else {
                log.debug("Mutating {}", (Object)muts.getKey());
            }
            if (mut.hasAdditions()) {
                for (KeyValueEntry entry : mut.getAdditions()) {
                    store.insert(entry.getKey(), entry.getValue(), txh);
                    log.trace("Insertion on {}: {}", (Object)muts.getKey(), (Object)entry);
                }
            }
            if (!mut.hasDeletions()) continue;
            for (StaticBuffer del : mut.getDeletions()) {
                store.delete(del, txh);
                log.trace("Deletion on {}: {}", (Object)muts.getKey(), (Object)del);
            }
        }
    }

    void removeDatabase(BerkeleyJEKeyValueStore db) {
        if (!this.stores.containsKey(db.getName())) {
            throw new IllegalArgumentException("Tried to remove an unkown database from the storage manager");
        }
        String name = db.getName();
        this.stores.remove(name);
        log.debug("Removed database {}", (Object)name);
    }

    public void close() throws BackendException {
        if (this.environment != null) {
            if (!this.stores.isEmpty()) {
                throw new IllegalStateException("Cannot shutdown manager since some databases are still open");
            }
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.environment.close();
            }
            catch (DatabaseException e) {
                throw new PermanentBackendException("Could not close BerkeleyJE database", (Throwable)e);
            }
        }
    }

    public void clearStorage() throws BackendException {
        if (!this.stores.isEmpty()) {
            throw new IllegalStateException("Cannot delete store, since database is open: " + this.stores.keySet().toString());
        }
        Transaction tx = null;
        for (String db : this.environment.getDatabaseNames()) {
            this.environment.removeDatabase(tx, db);
            log.debug("Removed database {} (clearStorage)", (Object)db);
        }
        this.close();
        IOUtils.deleteFromDirectory((File)this.directory);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.directory.toString();
    }

    private static class TransactionBegin
    extends Exception {
        private static final long serialVersionUID = 1L;

        private TransactionBegin(String msg) {
            super(msg);
        }
    }

    public static enum IsolationLevel {
        READ_UNCOMMITTED{

            @Override
            void configure(TransactionConfig cfg) {
                cfg.setReadUncommitted(true);
            }
        }
        ,
        READ_COMMITTED{

            @Override
            void configure(TransactionConfig cfg) {
                cfg.setReadCommitted(true);
            }
        }
        ,
        REPEATABLE_READ{

            @Override
            void configure(TransactionConfig cfg) {
            }
        }
        ,
        SERIALIZABLE{

            @Override
            void configure(TransactionConfig cfg) {
                cfg.setSerializableIsolation(true);
            }
        };


        abstract void configure(TransactionConfig var1);
    }
}

