/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.agroal.internal;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalPropertiesReader;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

public class AgroalConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    public static final String CONFIG_PREFIX = "hibernate.agroal.";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AgroalConnectionProvider.class);
    private AgroalDataSource agroalDataSource = null;

    private static void resolveIsolationSetting(Map<String, String> properties, AgroalConnectionFactoryConfigurationSupplier cf) {
        Integer isolation = ConnectionProviderInitiator.extractIsolation(properties);
        if (isolation != null) {
            String isolationString = ConnectionProviderInitiator.toIsolationNiceName((Integer)isolation);
            cf.jdbcTransactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation.valueOf((String)isolationString));
        }
    }

    private static <T> void copyProperty(Map<String, String> properties, String key, Consumer<T> consumer, Function<String, T> converter) {
        String value = properties.get(key);
        if (value != null) {
            consumer.accept(converter.apply(value));
        }
    }

    public void configure(Map props) throws HibernateException {
        LOGGER.debug((Object)"Configuring Agroal");
        try {
            AgroalPropertiesReader agroalProperties = new AgroalPropertiesReader(CONFIG_PREFIX).readProperties(props);
            agroalProperties.modify().connectionPoolConfiguration(cp -> cp.connectionFactoryConfiguration(cf -> {
                AgroalConnectionProvider.copyProperty(props, "hibernate.connection.driver_class", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).connectionProviderClassName(arg_0), Function.identity());
                AgroalConnectionProvider.copyProperty(props, "hibernate.connection.url", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).jdbcUrl(arg_0), Function.identity());
                AgroalConnectionProvider.copyProperty(props, "hibernate.connection.username", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).principal(arg_0), NamePrincipal::new);
                AgroalConnectionProvider.copyProperty(props, "hibernate.connection.password", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).credential(arg_0), SimplePassword::new);
                AgroalConnectionProvider.copyProperty(props, "hibernate.connection.autocommit", arg_0 -> ((AgroalConnectionFactoryConfigurationSupplier)cf).autoCommit(arg_0), Boolean::valueOf);
                AgroalConnectionProvider.resolveIsolationSetting(props, cf);
                return cf;
            }));
            this.agroalDataSource = AgroalDataSource.from((Supplier)agroalProperties, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
        LOGGER.debug((Object)"Agroal Configured");
    }

    public Connection getConnection() throws SQLException {
        return this.agroalDataSource == null ? null : this.agroalDataSource.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || AgroalConnectionProvider.class.isAssignableFrom(unwrapType) || DataSource.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || AgroalConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(unwrapType)) {
            return (T)this.agroalDataSource;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        this.agroalDataSource.close();
    }
}

