/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.transaction.Synchronization;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.envers.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.synchronization.AuditSyncManager;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.tools.Pair;
import org.hibernate.event.EventSource;

public class AuditSync
implements Synchronization {
    private final RevisionInfoGenerator revisionInfoGenerator;
    private final AuditSyncManager manager;
    private final EventSource session;
    private final Transaction transaction;
    private final LinkedList<AuditWorkUnit> workUnits;
    private final Queue<AuditWorkUnit> undoQueue;
    private final Map<Pair<String, Object>, AuditWorkUnit> usedIds;
    private Object revisionData;

    public AuditSync(AuditSyncManager manager, EventSource session, RevisionInfoGenerator revisionInfoGenerator) {
        this.manager = manager;
        this.session = session;
        this.revisionInfoGenerator = revisionInfoGenerator;
        this.transaction = session.getTransaction();
        this.workUnits = new LinkedList();
        this.undoQueue = new LinkedList<AuditWorkUnit>();
        this.usedIds = new HashMap<Pair<String, Object>, AuditWorkUnit>();
    }

    private void removeWorkUnit(AuditWorkUnit vwu) {
        this.workUnits.remove(vwu);
        if (vwu.isPerformed()) {
            this.undoQueue.offer(vwu);
        }
    }

    public void addWorkUnit(AuditWorkUnit vwu) {
        if (vwu.containsWork()) {
            Object entityId = vwu.getEntityId();
            if (entityId == null) {
                this.workUnits.offer(vwu);
            } else {
                String entityName = vwu.getEntityName();
                Pair<String, Object> usedIdsKey = Pair.make(entityName, entityId);
                if (this.usedIds.containsKey(usedIdsKey)) {
                    AuditWorkUnit other = this.usedIds.get(usedIdsKey);
                    AuditWorkUnit result = vwu.dispatch(other);
                    if (result != other) {
                        this.removeWorkUnit(other);
                        if (result != null) {
                            this.usedIds.put(usedIdsKey, result);
                            this.workUnits.offer(result);
                        }
                    }
                } else {
                    this.usedIds.put(usedIdsKey, vwu);
                    this.workUnits.offer(vwu);
                }
            }
        }
    }

    private void executeInSession(Session session) {
        AuditWorkUnit vwu;
        this.getCurrentRevisionData(session, true);
        while ((vwu = this.undoQueue.poll()) != null) {
            vwu.undo(session);
        }
        while ((vwu = this.workUnits.poll()) != null) {
            vwu.perform(session, this.revisionData);
        }
    }

    public Object getCurrentRevisionData(Session session, boolean persist) {
        if (this.revisionData == null) {
            this.revisionData = this.revisionInfoGenerator.generate();
        }
        if (!session.contains(this.revisionData) && persist) {
            this.revisionInfoGenerator.saveRevisionData(session, this.revisionData);
        }
        return this.revisionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        block12: {
            if (this.workUnits.size() == 0 && this.undoQueue.size() == 0) {
                return;
            }
            try {
                if (FlushMode.isManualFlushMode((FlushMode)this.session.getFlushMode()) || this.session.isClosed()) {
                    org.hibernate.classic.Session temporarySession = null;
                    try {
                        temporarySession = this.session.getFactory().openTemporarySession();
                        this.executeInSession((Session)temporarySession);
                        temporarySession.flush();
                        break block12;
                    }
                    finally {
                        if (temporarySession != null) {
                            temporarySession.close();
                        }
                    }
                }
                this.executeInSession((Session)this.session);
                this.session.flush();
            }
            catch (RuntimeException e) {
                try {
                    if (this.session.getTransaction().isActive()) {
                        this.session.getTransaction().rollback();
                    }
                }
                finally {
                    throw e;
                }
            }
        }
    }

    public void afterCompletion(int i) {
        this.manager.remove(this.transaction);
    }
}

