/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.NoResultException;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.exception.NotAuditedException;
import org.hibernate.envers.exception.RevisionDoesNotExistException;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQueryCreator;
import org.hibernate.envers.query.criteria.RevisionTypeAuditExpression;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.reader.FirstLevelCache;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.envers.tools.ArgumentsTools;
import org.hibernate.envers.tools.Tools;
import org.hibernate.event.spi.EventSource;
import org.hibernate.proxy.HibernateProxy;

public class AuditReaderImpl
implements AuditReaderImplementor {
    private final AuditConfiguration verCfg;
    private final SessionImplementor sessionImplementor;
    private final Session session;
    private final FirstLevelCache firstLevelCache;

    public AuditReaderImpl(AuditConfiguration verCfg, Session session, SessionImplementor sessionImplementor) {
        this.verCfg = verCfg;
        this.sessionImplementor = sessionImplementor;
        this.session = session;
        this.firstLevelCache = new FirstLevelCache();
    }

    private void checkSession() {
        if (!this.session.isOpen()) {
            throw new IllegalStateException("The associated entity manager is closed!");
        }
    }

    @Override
    public SessionImplementor getSessionImplementor() {
        return this.sessionImplementor;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public FirstLevelCache getFirstLevelCache() {
        return this.firstLevelCache;
    }

    @Override
    public <T> T find(Class<T> cls, Object primaryKey, Number revision) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        cls = Tools.getTargetClassIfProxied(cls);
        return this.find(cls, cls.getName(), primaryKey, revision);
    }

    @Override
    public <T> T find(Class<T> cls, String entityName, Object primaryKey, Number revision) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        Object result;
        cls = Tools.getTargetClassIfProxied(cls);
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(entityName, "Entity name");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        if (!this.verCfg.getEntCfg().isVersioned(entityName)) {
            throw new NotAuditedException(entityName, entityName + " is not versioned!");
        }
        if (this.firstLevelCache.contains(entityName, revision, primaryKey)) {
            return (T)this.firstLevelCache.get(entityName, revision, primaryKey);
        }
        try {
            result = this.createQuery().forEntitiesAtRevision(cls, entityName, revision).add(AuditEntity.id().eq(primaryKey)).getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
        return (T)result;
    }

    @Override
    public List<Number> getRevisions(Class<?> cls, Object primaryKey) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        cls = Tools.getTargetClassIfProxied(cls);
        return this.getRevisions(cls, cls.getName(), primaryKey);
    }

    @Override
    public List<Number> getRevisions(Class<?> cls, String entityName, Object primaryKey) throws IllegalArgumentException, NotAuditedException, IllegalStateException {
        cls = Tools.getTargetClassIfProxied(cls);
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(entityName, "Entity name");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        this.checkSession();
        if (!this.verCfg.getEntCfg().isVersioned(entityName)) {
            throw new NotAuditedException(entityName, entityName + " is not versioned!");
        }
        return this.createQuery().forRevisionsOfEntity(cls, entityName, false, true).addProjection(AuditEntity.revisionNumber()).add(AuditEntity.id().eq(primaryKey)).getResultList();
    }

    @Override
    public Date getRevisionDate(Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        Criteria query = this.verCfg.getRevisionInfoQueryCreator().getRevisionDateQuery(this.session, revision);
        try {
            Object timestampObject = query.uniqueResult();
            if (timestampObject == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return timestampObject instanceof Date ? (Date)timestampObject : new Date((Long)timestampObject);
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public Number getRevisionNumberForDate(Date date) {
        ArgumentsTools.checkNotNull(date, "Date of revision");
        this.checkSession();
        Criteria query = this.verCfg.getRevisionInfoQueryCreator().getRevisionNumberForDateQuery(this.session, date);
        try {
            Number res = (Number)query.uniqueResult();
            if (res == null) {
                throw new RevisionDoesNotExistException(date);
            }
            return res;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public <T> T findRevision(Class<T> revisionEntityClass, Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        revisionEntityClass = Tools.getTargetClassIfProxied(revisionEntityClass);
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        HashSet<Number> revisions = new HashSet<Number>(1);
        revisions.add(revision);
        Criteria query = this.verCfg.getRevisionInfoQueryCreator().getRevisionsQuery(this.session, revisions);
        try {
            Object revisionData = query.uniqueResult();
            if (revisionData == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return (T)revisionData;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public <T> Map<Number, T> findRevisions(Class<T> revisionEntityClass, Set<Number> revisions) throws IllegalArgumentException, IllegalStateException {
        revisionEntityClass = Tools.getTargetClassIfProxied(revisionEntityClass);
        HashMap result = new HashMap(revisions.size());
        for (Number revision : revisions) {
            ArgumentsTools.checkNotNull(revision, "Entity revision");
            ArgumentsTools.checkPositive(revision, "Entity revision");
        }
        this.checkSession();
        Criteria query = this.verCfg.getRevisionInfoQueryCreator().getRevisionsQuery(this.session, revisions);
        try {
            List revisionList = query.list();
            for (Object revision : revisionList) {
                Number revNo = this.verCfg.getRevisionInfoNumberReader().getRevisionNumber(revision);
                result.put(revNo, revision);
            }
            return result;
        }
        catch (HibernateException e) {
            throw new AuditException(e);
        }
    }

    @Override
    public List<Object> findEntitiesChangedInRevision(Number revision) throws IllegalStateException, IllegalArgumentException, AuditException {
        Set<Class> clazz = this.findEntityTypesChangedInRevision(revision);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Class c : clazz) {
            result.addAll(this.createQuery().forEntitiesModifiedAtRevision(c, revision).getResultList());
        }
        return result;
    }

    @Override
    public List<Object> findEntitiesChangedInRevision(Number revision, RevisionType revisionType) throws IllegalStateException, IllegalArgumentException, AuditException {
        Set<Class> clazz = this.findEntityTypesChangedInRevision(revision);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Class c : clazz) {
            result.addAll(this.createQuery().forEntitiesModifiedAtRevision(c, revision).add(new RevisionTypeAuditExpression((Object)revisionType, "=")).getResultList());
        }
        return result;
    }

    @Override
    public Map<RevisionType, List<Object>> findEntitiesChangedInRevisionGroupByRevisionType(Number revision) throws IllegalStateException, IllegalArgumentException, AuditException {
        Set<Class> clazz = this.findEntityTypesChangedInRevision(revision);
        HashMap<RevisionType, List<Object>> result = new HashMap<RevisionType, List<Object>>();
        for (RevisionType revisionType : RevisionType.values()) {
            result.put(revisionType, new ArrayList());
            for (Class c : clazz) {
                List list = this.createQuery().forEntitiesModifiedAtRevision(c, revision).add(new RevisionTypeAuditExpression((Object)revisionType, "=")).getResultList();
                ((List)result.get((Object)revisionType)).addAll(list);
            }
        }
        return result;
    }

    @Override
    public Set<Class> findEntityTypesChangedInRevision(Number revision) throws IllegalStateException, IllegalArgumentException, AuditException {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        if (!this.verCfg.getGlobalCfg().isTrackEntitiesChangedInRevisionEnabled()) {
            throw new AuditException("This query is designed for Envers default mechanism of tracking entities modified in a given revision. Extend DefaultTrackingModifiedTypesRevisionEntity, utilize @ModifiedEntityTypes annotation or set 'org.hibernate.envers.track_entities_changed_in_revision' parameter to true.");
        }
        HashSet<Number> revisions = new HashSet<Number>(1);
        revisions.add(revision);
        Criteria query = this.verCfg.getRevisionInfoQueryCreator().getRevisionsQuery(this.session, revisions);
        Object revisionInfo = query.uniqueResult();
        if (revisionInfo != null) {
            return this.verCfg.getModifiedEntityTypesReader().getModifiedEntityTypes(revisionInfo);
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public <T> T getCurrentRevision(Class<T> revisionEntityClass, boolean persist) {
        revisionEntityClass = Tools.getTargetClassIfProxied(revisionEntityClass);
        if (!(this.session instanceof EventSource)) {
            throw new IllegalArgumentException("The provided session is not an EventSource!");
        }
        AuditProcess auditProcess = this.verCfg.getSyncManager().get((EventSource)this.session);
        return (T)auditProcess.getCurrentRevisionData(this.session, persist);
    }

    @Override
    public AuditQueryCreator createQuery() {
        return new AuditQueryCreator(this.verCfg, this);
    }

    @Override
    public boolean isEntityClassAudited(Class<?> entityClass) {
        entityClass = Tools.getTargetClassIfProxied(entityClass);
        return this.isEntityNameAudited(entityClass.getName());
    }

    @Override
    public boolean isEntityNameAudited(String entityName) {
        ArgumentsTools.checkNotNull(entityName, "Entity name");
        this.checkSession();
        return this.verCfg.getEntCfg().isVersioned(entityName);
    }

    @Override
    public String getEntityName(Object primaryKey, Number revision, Object entity) throws HibernateException {
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        ArgumentsTools.checkNotNull(entity, "Entity");
        this.checkSession();
        if (entity instanceof HibernateProxy) {
            entity = ((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
        }
        if (this.firstLevelCache.containsEntityName(primaryKey, revision, entity)) {
            return this.firstLevelCache.getFromEntityNameCache(primaryKey, revision, entity);
        }
        throw new HibernateException("Envers can't resolve entityName for historic entity. The id, revision and entity is not on envers first level cache.");
    }
}

