/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.revisioninfo;

import java.io.Serializable;
import java.util.HashSet;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.revisioninfo.DefaultRevisionInfoGenerator;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;

public class DefaultTrackingModifiedTypesRevisionInfoGenerator
extends DefaultRevisionInfoGenerator {
    private final Setter modifiedEntityTypesSetter;
    private final Getter modifiedEntityTypesGetter;

    public DefaultTrackingModifiedTypesRevisionInfoGenerator(String revisionInfoEntityName, Class<?> revisionInfoClass, Class<? extends RevisionListener> listenerClass, PropertyData revisionInfoTimestampData, boolean timestampAsDate, PropertyData modifiedEntityTypesData) {
        super(revisionInfoEntityName, revisionInfoClass, listenerClass, revisionInfoTimestampData, timestampAsDate);
        this.modifiedEntityTypesSetter = ReflectionTools.getSetter(revisionInfoClass, modifiedEntityTypesData);
        this.modifiedEntityTypesGetter = ReflectionTools.getGetter(revisionInfoClass, modifiedEntityTypesData);
    }

    @Override
    public void entityChanged(Class entityClass, String entityName, Serializable entityId, RevisionType revisionType, Object revisionEntity) {
        super.entityChanged(entityClass, entityName, entityId, revisionType, revisionEntity);
        HashSet<String> modifiedEntityTypes = (HashSet<String>)this.modifiedEntityTypesGetter.get(revisionEntity);
        if (modifiedEntityTypes == null) {
            modifiedEntityTypes = new HashSet<String>();
            this.modifiedEntityTypesSetter.set(revisionEntity, modifiedEntityTypes, null);
        }
        modifiedEntityTypes.add(entityClass.getName());
    }
}

