/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration;

import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.tools.Tools;

public class GlobalConfiguration {
    public static final String GLOBAL_WITH_MODIFIED_FLAG_PROPERTY = "org.hibernate.envers.global_with_modified_flag";
    public static final String MODIFIED_FLAG_SUFFIX_PROPERTY = "org.hibernate.envers.modified_flag_suffix";
    public static final String DEFAULT_MODIFIED_FLAG_SUFFIX = "_MOD";
    private final boolean generateRevisionsForCollections;
    private final boolean doNotAuditOptimisticLockingField;
    private final boolean storeDataAtDelete;
    private final String defaultSchemaName;
    private final String defaultCatalogName;
    private boolean trackEntitiesChangedInRevisionEnabled;
    private final Class<? extends RevisionListener> revisionListenerClass;
    private boolean globalWithModifiedFlag;
    private boolean hasGlobalSettingForWithModifiedFlag;
    private String modifiedFlagSuffix;
    private final boolean useRevisionEntityWithNativeId;
    private final String correlatedSubqueryOperator;

    public GlobalConfiguration(Properties properties) {
        String generateRevisionsForCollectionsStr = Tools.getProperty(properties, "org.hibernate.envers.revision_on_collection_change", "org.hibernate.envers.revisionOnCollectionChange", "true");
        this.generateRevisionsForCollections = Boolean.parseBoolean(generateRevisionsForCollectionsStr);
        String ignoreOptimisticLockingPropertyStr = Tools.getProperty(properties, "org.hibernate.envers.do_not_audit_optimistic_locking_field", "org.hibernate.envers.doNotAuditOptimisticLockingField", "true");
        this.doNotAuditOptimisticLockingField = Boolean.parseBoolean(ignoreOptimisticLockingPropertyStr);
        String storeDataDeletedEntityStr = Tools.getProperty(properties, "org.hibernate.envers.store_data_at_delete", "org.hibernate.envers.storeDataAtDelete", "false");
        this.storeDataAtDelete = Boolean.parseBoolean(storeDataDeletedEntityStr);
        this.defaultSchemaName = properties.getProperty("org.hibernate.envers.default_schema", null);
        this.defaultCatalogName = properties.getProperty("org.hibernate.envers.default_catalog", null);
        this.correlatedSubqueryOperator = "org.hibernate.dialect.HSQLDialect".equals(properties.getProperty("hibernate.dialect")) ? "in" : "=";
        String trackEntitiesChangedInRevisionEnabledStr = Tools.getProperty(properties, "org.hibernate.envers.track_entities_changed_in_revision", "org.hibernate.envers.track_entities_changed_in_revision", "false");
        this.trackEntitiesChangedInRevisionEnabled = Boolean.parseBoolean(trackEntitiesChangedInRevisionEnabledStr);
        String useRevisionEntityWithNativeIdStr = Tools.getProperty(properties, "org.hibernate.envers.use_revision_entity_with_native_id", "org.hibernate.envers.use_revision_entity_with_native_id", "true");
        this.useRevisionEntityWithNativeId = Boolean.parseBoolean(useRevisionEntityWithNativeIdStr);
        this.hasGlobalSettingForWithModifiedFlag = properties.getProperty(GLOBAL_WITH_MODIFIED_FLAG_PROPERTY) != null;
        String usingModifiedFlagStr = Tools.getProperty(properties, GLOBAL_WITH_MODIFIED_FLAG_PROPERTY, GLOBAL_WITH_MODIFIED_FLAG_PROPERTY, "false");
        this.globalWithModifiedFlag = Boolean.parseBoolean(usingModifiedFlagStr);
        this.modifiedFlagSuffix = Tools.getProperty(properties, MODIFIED_FLAG_SUFFIX_PROPERTY, MODIFIED_FLAG_SUFFIX_PROPERTY, DEFAULT_MODIFIED_FLAG_SUFFIX);
        String revisionListenerClassName = properties.getProperty("org.hibernate.envers.revision_listener", null);
        if (revisionListenerClassName != null) {
            try {
                this.revisionListenerClass = Thread.currentThread().getContextClassLoader().loadClass(revisionListenerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Revision listener class not found: " + revisionListenerClassName + ".", (Throwable)e);
            }
        } else {
            this.revisionListenerClass = null;
        }
    }

    public boolean isGenerateRevisionsForCollections() {
        return this.generateRevisionsForCollections;
    }

    public boolean isDoNotAuditOptimisticLockingField() {
        return this.doNotAuditOptimisticLockingField;
    }

    public String getCorrelatedSubqueryOperator() {
        return this.correlatedSubqueryOperator;
    }

    public boolean isStoreDataAtDelete() {
        return this.storeDataAtDelete;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public boolean isTrackEntitiesChangedInRevisionEnabled() {
        return this.trackEntitiesChangedInRevisionEnabled;
    }

    public void setTrackEntitiesChangedInRevisionEnabled(boolean trackEntitiesChangedInRevisionEnabled) {
        this.trackEntitiesChangedInRevisionEnabled = trackEntitiesChangedInRevisionEnabled;
    }

    public Class<? extends RevisionListener> getRevisionListenerClass() {
        return this.revisionListenerClass;
    }

    public boolean hasSettingForUsingModifiedFlag() {
        return this.hasGlobalSettingForWithModifiedFlag;
    }

    public boolean isGlobalWithModifiedFlag() {
        return this.globalWithModifiedFlag;
    }

    public String getModifiedFlagSuffix() {
        return this.modifiedFlagSuffix;
    }

    public boolean isUseRevisionEntityWithNativeId() {
        return this.useRevisionEntityWithNativeId;
    }
}

