/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.HibernateException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.AdditionalJaxbMappingProducer;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class AdditionalJaxbMappingProducerImpl
implements AdditionalJaxbMappingProducer {
    private static final Logger log = Logger.getLogger(AdditionalJaxbMappingProducerImpl.class);

    public Collection<MappingDocument> produceAdditionalMappings(MetadataImplementor metadata, IndexView jandexIndex, final MappingBinder mappingBinder, final MetadataBuildingContext buildingContext) {
        StandardServiceRegistry serviceRegistry = metadata.getMetadataBuildingOptions().getServiceRegistry();
        EnversService enversService = (EnversService)serviceRegistry.getService(EnversService.class);
        if (!enversService.isEnabled()) {
            return Collections.emptyList();
        }
        final ArrayList<MappingDocument> additionalMappingDocuments = new ArrayList<MappingDocument>();
        final Origin origin = new Origin(SourceType.OTHER, "envers");
        MappingCollector mappingCollector = new MappingCollector(){

            @Override
            public void addDocument(Document document) throws DocumentException {
                AdditionalJaxbMappingProducerImpl.dump(document);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter w = new PrintWriter(baos);
                try {
                    XMLWriter xw = new XMLWriter((Writer)w, new OutputFormat(" ", true));
                    xw.write(document);
                    ((Writer)w).flush();
                }
                catch (IOException e) {
                    throw new HibernateException("Unable to bind Envers-generated XML", (Throwable)e);
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                BufferedInputStream bis = new BufferedInputStream(bais);
                Binding jaxbBinding = mappingBinder.bind((InputStream)bis, origin);
                JaxbHbmHibernateMapping jaxbRoot = (JaxbHbmHibernateMapping)jaxbBinding.getRoot();
                additionalMappingDocuments.add(new MappingDocument(jaxbRoot, origin, buildingContext));
            }
        };
        enversService.initialize(metadata, mappingCollector);
        return additionalMappingDocuments;
    }

    private static void dump(Document document) {
        if (!log.isTraceEnabled()) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(baos);
        try {
            XMLWriter xw = new XMLWriter((Writer)w, new OutputFormat(" ", true));
            xw.write(document);
            ((Writer)w).flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        log.tracef("Envers-generate entity mapping -----------------------------\n%s", (Object)baos.toString());
        log.trace((Object)"------------------------------------------------------------");
    }
}

