/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.EnumType;
import javax.persistence.JoinColumn;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.configuration.internal.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.configuration.internal.metadata.EntityXmlMappingData;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.configuration.internal.metadata.QueryGeneratorBuilder;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SinglePropertyMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.BasicCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.ListCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MapCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleMapKeyEnumeratedComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.SortedMapCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.SortedSetCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.ToOneIdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleDummyComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleEmbeddableComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleMapElementNotKeyComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleMapKeyIdComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleMapKeyPropertyComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleRelatedComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleSimpleComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleStraightComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.ListProxy;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.MapProxy;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.SetProxy;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.SortedMapProxy;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.SortedSetProxy;
import org.hibernate.envers.internal.entities.mapper.relation.query.OneAuditEntityQueryGenerator;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.BagType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.ListType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MapType;
import org.hibernate.type.MaterializedClobType;
import org.hibernate.type.MaterializedNClobType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedMapType;
import org.hibernate.type.SortedSetType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public final class CollectionMetadataGenerator {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)CollectionMetadataGenerator.class.getName());
    private final AuditMetadataGenerator mainGenerator;
    private final String propertyName;
    private final Collection propertyValue;
    private final CompositeMapperBuilder currentMapper;
    private final String referencingEntityName;
    private final EntityXmlMappingData xmlMappingData;
    private final PropertyAuditingData propertyAuditingData;
    private final EntityConfiguration referencingEntityConfiguration;
    private final String referencedEntityName;

    public CollectionMetadataGenerator(AuditMetadataGenerator mainGenerator, Collection propertyValue, CompositeMapperBuilder currentMapper, String referencingEntityName, EntityXmlMappingData xmlMappingData, PropertyAuditingData propertyAuditingData) {
        this.mainGenerator = mainGenerator;
        this.propertyValue = propertyValue;
        this.currentMapper = currentMapper;
        this.referencingEntityName = referencingEntityName;
        this.xmlMappingData = xmlMappingData;
        this.propertyAuditingData = propertyAuditingData;
        this.propertyName = propertyAuditingData.getName();
        this.referencingEntityConfiguration = mainGenerator.getEntitiesConfigurations().get(referencingEntityName);
        if (this.referencingEntityConfiguration == null) {
            throw new MappingException("Unable to read auditing configuration for " + referencingEntityName + "!");
        }
        this.referencedEntityName = MappingTools.getReferencedEntityName(propertyValue.getElement());
    }

    void addCollection() {
        boolean fakeOneToManyBidirectional;
        Type type = this.propertyValue.getType();
        Value value = this.propertyValue.getElement();
        boolean oneToManyAttachedType = type instanceof BagType || type instanceof SetType || type instanceof MapType || type instanceof ListType;
        boolean inverseOneToMany = value instanceof OneToMany && this.propertyValue.isInverse();
        boolean owningManyToOneWithJoinTableBidirectional = value instanceof ManyToOne && this.propertyAuditingData.getRelationMappedBy() != null;
        boolean bl = fakeOneToManyBidirectional = value instanceof OneToMany && this.propertyAuditingData.getAuditMappedBy() != null;
        if (oneToManyAttachedType && (inverseOneToMany || fakeOneToManyBidirectional || owningManyToOneWithJoinTableBidirectional)) {
            this.addOneToManyAttached(fakeOneToManyBidirectional);
        } else {
            this.addWithMiddleTable();
        }
    }

    private MiddleIdData createMiddleIdData(IdMappingData idMappingData, String prefix, String entityName) {
        return new MiddleIdData(this.mainGenerator.getVerEntCfg(), idMappingData, prefix, entityName, this.mainGenerator.getEntitiesConfigurations().containsKey(entityName));
    }

    private void addOneToManyAttached(boolean fakeOneToManyBidirectional) {
        SinglePropertyMapper fakeBidirectionalRelationIndexMapper;
        ToOneIdMapper fakeBidirectionalRelationMapper;
        LOG.debugf("Adding audit mapping for property %s.%s: one-to-many collection, using a join column on the referenced entity", this.referencingEntityName, this.propertyName);
        boolean indexed = this.propertyValue instanceof IndexedCollection && ((IndexedCollection)this.propertyValue).getIndex() != null;
        String mappedBy = this.getMappedBy(this.propertyValue);
        IdMappingData referencedIdMapping = this.mainGenerator.getReferencedIdMappingData(this.referencingEntityName, this.referencedEntityName, this.propertyAuditingData, false);
        IdMappingData referencingIdMapping = this.referencingEntityConfiguration.getIdMappingData();
        MiddleIdData referencingIdData = this.createMiddleIdData(referencingIdMapping, mappedBy + "_", this.referencingEntityName);
        MiddleIdData referencedIdData = this.createMiddleIdData(referencedIdMapping, null, this.referencedEntityName);
        MiddleComponentData elementComponentData = new MiddleComponentData(new MiddleRelatedComponentMapper(referencedIdData), 0);
        MiddleComponentData indexComponentData = this.addIndex(null, null);
        OneAuditEntityQueryGenerator queryGenerator = new OneAuditEntityQueryGenerator(this.mainGenerator.getGlobalCfg(), this.mainGenerator.getVerEntCfg(), this.mainGenerator.getAuditStrategy(), referencingIdData, this.referencedEntityName, referencedIdData, this.isEmbeddableElementType(), mappedBy, this.isMappedByKey(this.propertyValue, mappedBy), this.propertyValue.getOrderBy());
        CommonCollectionMapperData commonCollectionMapperData = new CommonCollectionMapperData(this.mainGenerator.getVerEntCfg(), this.referencedEntityName, this.propertyAuditingData.getPropertyData(), referencingIdData, queryGenerator, this.propertyValue.getRole());
        if (fakeOneToManyBidirectional || indexed) {
            String positionMappedBy;
            String auditMappedBy = fakeOneToManyBidirectional ? this.propertyAuditingData.getAuditMappedBy() : this.propertyValue.getMappedByProperty();
            IdMapper relMapper = referencingIdMapping.getIdMapper().prefixMappedProperties(MappingTools.createToOneRelationPrefix(auditMappedBy));
            fakeBidirectionalRelationMapper = new ToOneIdMapper(relMapper, new PropertyData(auditMappedBy, null, null, null), this.referencingEntityName, false);
            if (fakeOneToManyBidirectional) {
                positionMappedBy = this.propertyAuditingData.getPositionMappedBy();
            } else if (indexed) {
                Value indexValue = ((IndexedCollection)this.propertyValue).getIndex();
                positionMappedBy = ((Selectable)indexValue.getColumnIterator().next()).getText();
            } else {
                positionMappedBy = null;
            }
            if (positionMappedBy != null) {
                Type indexType = IndexedCollection.class.isInstance(this.propertyValue) ? ((IndexedCollection)this.propertyValue).getIndex().getType() : null;
                fakeBidirectionalRelationIndexMapper = new SinglePropertyMapper(PropertyData.forProperty(positionMappedBy, indexType));
                indexComponentData = new MiddleComponentData(new MiddleStraightComponentMapper(positionMappedBy), 0);
            } else {
                fakeBidirectionalRelationIndexMapper = null;
            }
        } else {
            fakeBidirectionalRelationMapper = null;
            fakeBidirectionalRelationIndexMapper = null;
        }
        this.addMapper(commonCollectionMapperData, elementComponentData, indexComponentData);
        this.referencingEntityConfiguration.addToManyNotOwningRelation(this.propertyName, mappedBy, this.referencedEntityName, referencingIdData.getPrefixedMapper(), fakeBidirectionalRelationMapper, fakeBidirectionalRelationIndexMapper, indexed);
    }

    private void addRelatedToXmlMapping(Element xmlMapping, String prefix, MetadataTools.ColumnNameIterator columnNameIterator, IdMappingData relatedIdMapping) {
        Element properties = (Element)relatedIdMapping.getXmlRelationMapping().clone();
        MetadataTools.prefixNamesInPropertyElement(properties, prefix, columnNameIterator, true, true);
        for (Element idProperty : properties.elements()) {
            xmlMapping.add((Element)idProperty.clone());
        }
    }

    private String getMiddleTableName(Collection value, String entityName) {
        if (value.getElement() instanceof OneToMany && !value.isInverse()) {
            return StringTools.getLastComponent(entityName) + "_" + StringTools.getLastComponent(MappingTools.getReferencedEntityName(value.getElement()));
        }
        return value.getCollectionTable().getName();
    }

    private void addWithMiddleTable() {
        String referencedPrefix;
        String referencingPrefixRelated;
        String mappedBy;
        Element middleEntityXml;
        String auditMiddleEntityName;
        String auditMiddleTableName;
        LOG.debugf("Adding audit mapping for property %s.%s: collection with a join table", this.referencingEntityName, this.propertyName);
        if (!StringTools.isEmpty(this.propertyAuditingData.getJoinTable().name())) {
            auditMiddleTableName = this.propertyAuditingData.getJoinTable().name();
            auditMiddleEntityName = this.propertyAuditingData.getJoinTable().name();
        } else {
            String middleTableName = this.getMiddleTableName(this.propertyValue, this.referencingEntityName);
            auditMiddleTableName = this.mainGenerator.getVerEntCfg().getAuditTableName(null, middleTableName);
            auditMiddleEntityName = this.mainGenerator.getVerEntCfg().getAuditEntityName(middleTableName);
        }
        LOG.debugf("Using join table name: %s", auditMiddleTableName);
        if (!this.propertyValue.isInverse()) {
            auditMiddleEntityName = this.mainGenerator.getAuditEntityNameRegister().createUnique(auditMiddleEntityName);
            this.mainGenerator.getAuditEntityNameRegister().register(auditMiddleEntityName);
            middleEntityXml = this.createMiddleEntityXml(auditMiddleTableName, auditMiddleEntityName, this.propertyValue.getWhere());
        } else {
            middleEntityXml = null;
        }
        IdMappingData referencingIdMapping = this.referencingEntityConfiguration.getIdMappingData();
        if (this.propertyValue.isInverse()) {
            mappedBy = this.getMappedBy(this.propertyValue.getCollectionTable(), this.mainGenerator.getMetadata().getEntityBinding(this.referencedEntityName));
            referencingPrefixRelated = mappedBy + "_";
            referencedPrefix = StringTools.getLastComponent(this.referencedEntityName);
        } else {
            mappedBy = null;
            referencingPrefixRelated = StringTools.getLastComponent(this.referencingEntityName) + "_";
            referencedPrefix = this.referencedEntityName == null ? "element" : this.propertyName;
        }
        MiddleIdData referencingIdData = this.createMiddleIdData(referencingIdMapping, referencingPrefixRelated, this.referencingEntityName);
        QueryGeneratorBuilder queryGeneratorBuilder = new QueryGeneratorBuilder(this.mainGenerator.getGlobalCfg(), this.mainGenerator.getVerEntCfg(), this.mainGenerator.getAuditStrategy(), referencingIdData, auditMiddleEntityName, this.isRevisionTypeInId(), this.propertyValue.getOrderBy() == null ? this.propertyValue.getManyToManyOrdering() : this.propertyValue.getOrderBy());
        if (middleEntityXml != null) {
            this.addRelatedToXmlMapping(middleEntityXml, referencingPrefixRelated, MetadataTools.getColumnNameIterator(this.propertyValue.getKey().getColumnIterator()), referencingIdMapping);
        }
        MiddleComponentData elementComponentData = this.addValueToMiddleTable(this.propertyValue.getElement(), middleEntityXml, queryGeneratorBuilder, referencedPrefix, this.propertyAuditingData.getJoinTable().inverseJoinColumns(), !this.isLobMapElementType());
        MiddleComponentData indexComponentData = this.addIndex(middleEntityXml, queryGeneratorBuilder);
        RelationQueryGenerator queryGenerator = queryGeneratorBuilder.build(elementComponentData, indexComponentData);
        CommonCollectionMapperData commonCollectionMapperData = new CommonCollectionMapperData(this.mainGenerator.getVerEntCfg(), auditMiddleEntityName, this.propertyAuditingData.getPropertyData(), referencingIdData, queryGenerator, this.propertyValue.getRole());
        this.addMapper(commonCollectionMapperData, elementComponentData, indexComponentData);
        this.storeMiddleEntityRelationInformation(mappedBy);
    }

    private MiddleComponentData addIndex(Element middleEntityXml, QueryGeneratorBuilder queryGeneratorBuilder) {
        if (this.propertyValue instanceof IndexedCollection) {
            int currentIndex;
            IndexedCollection indexedValue = (IndexedCollection)this.propertyValue;
            String mapKey = this.propertyAuditingData.getMapKey();
            EnumType mapKeyEnumType = this.propertyAuditingData.getMapKeyEnumType();
            if (mapKey == null && mapKeyEnumType == null || mapKeyEnumType != null && this.referencedEntityName == null) {
                return this.addValueToMiddleTable(indexedValue.getIndex(), middleEntityXml, queryGeneratorBuilder, "mapkey", null, true);
            }
            if (mapKeyEnumType != null) {
                IdMappingData referencedIdMapping = this.mainGenerator.getEntitiesConfigurations().get(this.referencedEntityName).getIdMappingData();
                int currentIndex2 = queryGeneratorBuilder == null ? 0 : queryGeneratorBuilder.getCurrentIndex();
                return new MiddleComponentData(new MiddleMapKeyEnumeratedComponentMapper(this.propertyAuditingData.getName()), currentIndex2);
            }
            IdMappingData referencedIdMapping = this.mainGenerator.getEntitiesConfigurations().get(this.referencedEntityName).getIdMappingData();
            int n = currentIndex = queryGeneratorBuilder == null ? 0 : queryGeneratorBuilder.getCurrentIndex();
            if ("".equals(mapKey)) {
                return new MiddleComponentData(new MiddleMapKeyIdComponentMapper(this.mainGenerator.getVerEntCfg(), referencedIdMapping.getIdMapper()), currentIndex);
            }
            return new MiddleComponentData(new MiddleMapKeyPropertyComponentMapper(mapKey, this.propertyAuditingData.getAccessType()), currentIndex);
        }
        return new MiddleComponentData(new MiddleDummyComponentMapper(), 0);
    }

    private MiddleComponentData addValueToMiddleTable(Value value, Element xmlMapping, QueryGeneratorBuilder queryGeneratorBuilder, String prefix, JoinColumn[] joinColumns, boolean key) {
        Type type = value.getType();
        if (type instanceof ManyToOneType) {
            String prefixRelated = prefix + "_";
            String referencedEntityName = MappingTools.getReferencedEntityName(value);
            IdMappingData referencedIdMapping = this.mainGenerator.getReferencedIdMappingData(this.referencingEntityName, referencedEntityName, this.propertyAuditingData, true);
            if (xmlMapping != null) {
                this.addRelatedToXmlMapping(xmlMapping, prefixRelated, joinColumns != null && joinColumns.length > 0 ? MetadataTools.getColumnNameIterator(joinColumns) : MetadataTools.getColumnNameIterator(value.getColumnIterator()), referencedIdMapping);
            }
            MiddleIdData referencedIdData = this.createMiddleIdData(referencedIdMapping, prefixRelated, referencedEntityName);
            queryGeneratorBuilder.addRelation(referencedIdData);
            return new MiddleComponentData(new MiddleRelatedComponentMapper(referencedIdData), queryGeneratorBuilder.getCurrentIndex());
        }
        if (type instanceof ComponentType) {
            PropertyAuditingData nestedAuditingData;
            Component component = (Component)value;
            Class componentClass = ReflectionTools.loadClass(component.getComponentClassName(), this.mainGenerator.getClassLoaderService());
            MiddleEmbeddableComponentMapper componentMapper = new MiddleEmbeddableComponentMapper(new MultiPropertyMapper(), componentClass);
            Element parentXmlMapping = xmlMapping.getParent();
            ComponentAuditingData auditData = new ComponentAuditingData();
            ReflectionManager reflectionManager = this.mainGenerator.getMetadata().getMetadataBuildingOptions().getReflectionManager();
            new ComponentAuditedPropertiesReader(ModificationStore.FULL, new AuditedPropertiesReader.ComponentPropertiesSource(reflectionManager, component), auditData, this.mainGenerator.getGlobalCfg(), reflectionManager, "").read();
            for (String auditedPropertyName : auditData.getPropertyNames()) {
                nestedAuditingData = auditData.getPropertyAuditingData(auditedPropertyName);
                this.mainGenerator.addValue(parentXmlMapping, component.getProperty(auditedPropertyName).getValue(), componentMapper, prefix, this.xmlMappingData, nestedAuditingData, true, true, true);
            }
            for (String auditedPropertyName : auditData.getPropertyNames()) {
                nestedAuditingData = auditData.getPropertyAuditingData(auditedPropertyName);
                this.mainGenerator.addValue(parentXmlMapping, component.getProperty(auditedPropertyName).getValue(), componentMapper, this.referencingEntityName, this.xmlMappingData, nestedAuditingData, true, false, true);
            }
            if (this.propertyValue.isSet()) {
                String setOrdinalPropertyName = this.mainGenerator.getVerEntCfg().getEmbeddableSetOrdinalPropertyName();
                Element ordinalProperty = MetadataTools.addProperty(xmlMapping, setOrdinalPropertyName, "integer", true, true);
                MetadataTools.addColumn(ordinalProperty, setOrdinalPropertyName, null, null, null, null, null, null, false);
            }
            return new MiddleComponentData(componentMapper, 0);
        }
        boolean mapped = this.mainGenerator.getBasicMetadataGenerator().addBasic(key ? xmlMapping : xmlMapping.getParent(), new PropertyAuditingData(prefix, "field", ModificationStore.FULL, RelationTargetAuditMode.AUDITED, null, null, false), value, null, true, key);
        if (mapped && key) {
            return new MiddleComponentData(new MiddleSimpleComponentMapper(this.mainGenerator.getVerEntCfg(), prefix), 0);
        }
        if (mapped && !key) {
            return new MiddleComponentData(new MiddleMapElementNotKeyComponentMapper(this.mainGenerator.getVerEntCfg(), prefix), 0);
        }
        this.mainGenerator.throwUnsupportedTypeException(type, this.referencingEntityName, this.propertyName);
        throw new AssertionError();
    }

    private void addMapper(CommonCollectionMapperData commonCollectionMapperData, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        Type type = this.propertyValue.getType();
        boolean embeddableElementType = this.isEmbeddableElementType();
        boolean lobMapElementType = this.isLobMapElementType();
        if (type instanceof SortedSetType) {
            this.currentMapper.addComposite(this.propertyAuditingData.getPropertyData(), new SortedSetCollectionMapper(commonCollectionMapperData, TreeSet.class, SortedSetProxy.class, elementComponentData, this.propertyValue.getComparator(), embeddableElementType, embeddableElementType));
        } else if (type instanceof SetType) {
            this.currentMapper.addComposite(this.propertyAuditingData.getPropertyData(), new BasicCollectionMapper<SetProxy>(commonCollectionMapperData, HashSet.class, SetProxy.class, elementComponentData, embeddableElementType, embeddableElementType));
        } else if (type instanceof SortedMapType) {
            this.currentMapper.addComposite(this.propertyAuditingData.getPropertyData(), new SortedMapCollectionMapper(commonCollectionMapperData, TreeMap.class, SortedMapProxy.class, elementComponentData, indexComponentData, this.propertyValue.getComparator(), embeddableElementType || lobMapElementType));
        } else if (type instanceof MapType) {
            this.currentMapper.addComposite(this.propertyAuditingData.getPropertyData(), new MapCollectionMapper<MapProxy>(commonCollectionMapperData, HashMap.class, MapProxy.class, elementComponentData, indexComponentData, embeddableElementType || lobMapElementType));
        } else if (type instanceof BagType) {
            this.currentMapper.addComposite(this.propertyAuditingData.getPropertyData(), new BasicCollectionMapper<ListProxy>(commonCollectionMapperData, ArrayList.class, ListProxy.class, elementComponentData, embeddableElementType, embeddableElementType));
        } else if (type instanceof ListType) {
            this.currentMapper.addComposite(this.propertyAuditingData.getPropertyData(), new ListCollectionMapper(commonCollectionMapperData, elementComponentData, indexComponentData, embeddableElementType));
        } else {
            this.mainGenerator.throwUnsupportedTypeException(type, this.referencingEntityName, this.propertyName);
        }
    }

    private void storeMiddleEntityRelationInformation(String mappedBy) {
        if (this.referencedEntityName != null) {
            if (this.propertyValue.isInverse()) {
                this.referencingEntityConfiguration.addToManyMiddleNotOwningRelation(this.propertyName, mappedBy, this.referencedEntityName);
            } else {
                this.referencingEntityConfiguration.addToManyMiddleRelation(this.propertyName, this.referencedEntityName);
            }
        }
    }

    private Element createMiddleEntityXml(String auditMiddleTableName, String auditMiddleEntityName, String where) {
        String schema = this.mainGenerator.getSchema(this.propertyAuditingData.getJoinTable().schema(), this.propertyValue.getCollectionTable());
        String catalog = this.mainGenerator.getCatalog(this.propertyAuditingData.getJoinTable().catalog(), this.propertyValue.getCollectionTable());
        Element middleEntityXml = MetadataTools.createEntity(this.xmlMappingData.newAdditionalMapping(), new AuditTableData(auditMiddleEntityName, auditMiddleTableName, schema, catalog), null, null);
        Element middleEntityXmlId = middleEntityXml.addElement("composite-id");
        if (where != null) {
            middleEntityXml.addAttribute("where", where);
        }
        middleEntityXmlId.addAttribute("name", this.mainGenerator.getVerEntCfg().getOriginalIdPropName());
        this.mainGenerator.addRevisionInfoRelation(middleEntityXmlId);
        this.mainGenerator.addRevisionType(this.isRevisionTypeInId() ? middleEntityXmlId : middleEntityXml, middleEntityXml, this.isRevisionTypeInId());
        this.mainGenerator.addAdditionalColumns(middleEntityXml);
        return middleEntityXmlId;
    }

    private boolean isEmbeddableElementType() {
        return this.propertyValue.getElement().getType() instanceof ComponentType;
    }

    private String getMappedBy(Collection collectionValue) {
        PersistentClass referencedClass = this.getReferenceCollectionClass(collectionValue);
        ValueHolder valueHolder = new ValueHolder(collectionValue);
        return this.getMappedBy(referencedClass, valueHolder);
    }

    private String getMappedBy(Table collectionTable, PersistentClass referencedClass) {
        return this.getMappedBy(referencedClass, new ValueHolder(collectionTable));
    }

    private String getMappedBy(PersistentClass referencedClass, ValueHolder valueHolder) {
        String auditMappedBy = this.propertyAuditingData.getAuditMappedBy();
        if (auditMappedBy != null) {
            return auditMappedBy;
        }
        String mappedBy = this.searchMappedBy(referencedClass, valueHolder);
        if (mappedBy == null) {
            LOG.debugf("Going to search the mapped by attribute for %s in superclasses of entity: %s", this.propertyName, referencedClass.getClassName());
            PersistentClass tempClass = referencedClass;
            while (mappedBy == null && tempClass.getSuperclass() != null) {
                LOG.debugf("Searching in superclass: %s", tempClass.getSuperclass().getClassName());
                mappedBy = this.searchMappedBy(tempClass.getSuperclass(), valueHolder);
                tempClass = tempClass.getSuperclass();
            }
        }
        if (mappedBy == null) {
            throw new MappingException("Unable to read the mapped by attribute for " + this.propertyName + " in " + referencedClass.getClassName() + "!");
        }
        return mappedBy;
    }

    private String searchMappedBy(PersistentClass persistentClass, ValueHolder valueHolder) {
        if (valueHolder.getCollection() != null) {
            return this.searchMappedBy(persistentClass, valueHolder.getCollection());
        }
        return this.searchMappedBy(persistentClass, valueHolder.getTable());
    }

    private String searchMappedBy(PersistentClass referencedClass, Collection collectionValue) {
        Iterator assocClassProps = referencedClass.getPropertyIterator();
        while (assocClassProps.hasNext()) {
            Property property = (Property)assocClassProps.next();
            if (!Tools.iteratorsContentEqual(property.getValue().getColumnIterator(), collectionValue.getKey().getColumnIterator())) continue;
            return property.getName();
        }
        return this.searchMappedByKey(referencedClass, collectionValue);
    }

    private String searchMappedBy(PersistentClass referencedClass, Table collectionTable) {
        return this.searchMappedBy(referencedClass.getPropertyIterator(), collectionTable);
    }

    private String searchMappedBy(Iterator<Property> properties, Table collectionTable) {
        while (properties.hasNext()) {
            Component component;
            String mappedBy;
            Property property = properties.next();
            if (property.getValue() instanceof Collection) {
                if (((Collection)property.getValue()).getCollectionTable() != collectionTable) continue;
                return property.getName();
            }
            if (!(property.getValue() instanceof Component) || (mappedBy = this.searchMappedBy((component = (Component)property.getValue()).getPropertyIterator(), collectionTable)) == null) continue;
            return property.getName() + "_" + mappedBy;
        }
        return null;
    }

    private String searchMappedByKey(PersistentClass referencedClass, Collection collectionValue) {
        Iterator assocIdClassProps = referencedClass.getKeyClosureIterator();
        while (assocIdClassProps.hasNext()) {
            Value value = (Value)assocIdClassProps.next();
            if (!(value instanceof Component)) continue;
            Component component = (Component)value;
            Iterator componentPropertyIterator = component.getPropertyIterator();
            while (componentPropertyIterator.hasNext()) {
                Iterator collectionSelectables;
                Property property = (Property)componentPropertyIterator.next();
                Iterator propertySelectables = property.getValue().getColumnIterator();
                if (!Tools.iteratorsContentEqual(propertySelectables, collectionSelectables = collectionValue.getKey().getColumnIterator())) continue;
                return property.getName();
            }
        }
        return null;
    }

    private PersistentClass getReferenceCollectionClass(Collection collectionValue) {
        PersistentClass referencedClass = null;
        if (collectionValue.getElement() instanceof OneToMany) {
            OneToMany oneToManyValue = (OneToMany)collectionValue.getElement();
            referencedClass = oneToManyValue.getAssociatedClass();
        } else if (collectionValue.getElement() instanceof ManyToOne) {
            ManyToOne manyToOneValue = (ManyToOne)collectionValue.getElement();
            referencedClass = manyToOneValue.getMetadata().getEntityBinding(manyToOneValue.getReferencedEntityName());
        }
        return referencedClass;
    }

    private boolean isMappedByKey(Collection collectionValue, String mappedBy) {
        PersistentClass referencedClass = this.getReferenceCollectionClass(collectionValue);
        if (referencedClass != null) {
            String keyMappedBy = this.searchMappedByKey(referencedClass, collectionValue);
            return mappedBy.equals(keyMappedBy);
        }
        return false;
    }

    private boolean isRevisionTypeInId() {
        return this.isEmbeddableElementType() || this.isLobMapElementType();
    }

    private boolean isKeyRevisionTypeInId() {
        Type type;
        if (this.propertyValue instanceof Map && !(type = this.propertyValue.getKey().getType()).isComponentType() && !type.isAssociationType()) {
            return type instanceof MaterializedClobType || type instanceof MaterializedNClobType;
        }
        return false;
    }

    private boolean isLobMapElementType() {
        Type type;
        if (this.propertyValue instanceof Map && !(type = this.propertyValue.getElement().getType()).isComponentType() && !type.isAssociationType()) {
            return type instanceof MaterializedClobType || type instanceof MaterializedNClobType;
        }
        return false;
    }

    private boolean isMapElementInPrimaryKey() {
        if (this.propertyValue instanceof IndexedCollection) {
            Value index = ((IndexedCollection)this.propertyValue).getIndex();
            return !index.getType().isEntityType();
        }
        return true;
    }

    private class ValueHolder {
        private Collection collection;
        private Table table;

        public ValueHolder(Collection collection) {
            this.collection = collection;
        }

        public ValueHolder(Table table) {
            this.table = table;
        }

        public Collection getCollection() {
            return this.collection;
        }

        public Table getTable() {
            return this.table;
        }
    }
}

