/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.cfg.Environment;
import org.hibernate.orm.tooling.gradle.EnhanceExtension;

public class EnhancementHelper {
    static void enhance(SourceSet sourceSet, final EnhanceExtension options, Project project) {
        final ClassLoader classLoader = EnhancementHelper.toClassLoader(sourceSet.getCompileClasspath(), sourceSet.getOutput().getClassesDirs());
        DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

            public ClassLoader getLoadingClassLoader() {
                return classLoader;
            }

            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return options.getEnableAssociationManagement();
            }

            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return options.getEnableDirtyTracking();
            }

            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return options.getEnableLazyInitialization();
            }

            public boolean isLazyLoadable(UnloadedField field) {
                return options.getEnableLazyInitialization();
            }

            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return options.getEnableExtendedEnhancement();
            }
        };
        if (options.getEnableExtendedEnhancement()) {
            project.getLogger().warn("Extended enhancement is enabled. Classes other than entities may be modified. You should consider access the entities using getter/setter methods and disable this property. Use at your own risk.");
        }
        Enhancer enhancer = Environment.getBytecodeProvider().getEnhancer((EnhancementContext)enhancementContext);
        for (File classesDir : sourceSet.getOutput().getClassesDirs()) {
            ConfigurableFileTree fileTree = project.fileTree((Object)classesDir);
            for (File file : fileTree) {
                if (!file.getName().endsWith(".class")) continue;
                byte[] enhancedBytecode = EnhancementHelper.doEnhancement(classesDir, file, enhancer);
                if (enhancedBytecode != null) {
                    EnhancementHelper.writeOutEnhancedClass(enhancedBytecode, file, project.getLogger());
                    project.getLogger().info("Successfully enhanced class [" + file + "]");
                    continue;
                }
                project.getLogger().info("Skipping class [" + file.getAbsolutePath() + "], not an entity nor embeddable");
            }
        }
    }

    public static ClassLoader toClassLoader(FileCollection ... classpaths) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (FileCollection classpath : classpaths) {
            for (File file : classpath) {
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new GradleException("Unable to resolve classpath entry to URL : " + file.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Enhancer.class.getClassLoader());
    }

    static byte[] doEnhancement(File root, File javaClassFile, Enhancer enhancer) {
        try {
            String className = EnhancementHelper.determineClassName(root, javaClassFile);
            ByteArrayOutputStream originalBytes = new ByteArrayOutputStream();
            try (FileInputStream fileInputStream = new FileInputStream(javaClassFile);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = fileInputStream.read(buffer)) != -1) {
                    originalBytes.write(buffer, 0, length);
                }
            }
            return enhancer.enhance(className, originalBytes.toByteArray());
        }
        catch (Exception e) {
            throw new GradleException("Unable to enhance class : " + javaClassFile, (Throwable)e);
        }
    }

    private static String determineClassName(File root, File javaClassFile) {
        return javaClassFile.getAbsolutePath().substring(root.getAbsolutePath().length() + 1, javaClassFile.getAbsolutePath().length() - ".class".length()).replace(File.separatorChar, '.');
    }

    private static void writeOutEnhancedClass(byte[] enhancedBytecode, File file, Logger logger) {
        try {
            if (file.delete()) {
                if (!file.createNewFile()) {
                    logger.error("Unable to recreate class file [" + file.getName() + "]");
                }
            } else {
                logger.error("Unable to delete class file [" + file.getName() + "]");
            }
        }
        catch (IOException e) {
            logger.warn("Problem preparing class file for writing out enhancements [" + file.getName() + "]");
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file, false);
            try {
                outputStream.write(enhancedBytecode);
                outputStream.flush();
            }
            catch (IOException e) {
                throw new GradleException("Error writing to enhanced class [" + file.getName() + "] to file [" + file.getAbsolutePath() + "]", (Throwable)e);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            throw new GradleException("Error opening class file for writing : " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private EnhancementHelper() {
    }
}

