/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.tm;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.test.cache.infinispan.tm.XaTransactionImpl;

public class XaTransactionManagerImpl
implements TransactionManager {
    private static final XaTransactionManagerImpl INSTANCE = new XaTransactionManagerImpl();
    private XaTransactionImpl currentTransaction;

    public static XaTransactionManagerImpl getInstance() {
        return INSTANCE;
    }

    public int getStatus() throws SystemException {
        return this.currentTransaction == null ? 6 : this.currentTransaction.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.currentTransaction;
    }

    public XaTransactionImpl getCurrentTransaction() {
        return this.currentTransaction;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.currentTransaction = new XaTransactionImpl(this);
    }

    public Transaction suspend() throws SystemException {
        XaTransactionImpl suspended = this.currentTransaction;
        this.currentTransaction = null;
        return suspended;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.currentTransaction = (XaTransactionImpl)transaction;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.currentTransaction == null) {
            throw new IllegalStateException("no current transaction to commit");
        }
        this.currentTransaction.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.currentTransaction == null) {
            throw new IllegalStateException("no current transaction");
        }
        this.currentTransaction.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.currentTransaction == null) {
            throw new IllegalStateException("no current transaction");
        }
        this.currentTransaction.setRollbackOnly();
    }

    public void setTransactionTimeout(int i) throws SystemException {
    }

    void endCurrent(Transaction transaction) {
        if (transaction == this.currentTransaction) {
            this.currentTransaction = null;
        }
    }
}

