/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.util.AddressAdapter;
import org.hibernate.cache.infinispan.util.CacheAdapter;
import org.hibernate.cache.infinispan.util.FlagAdapter;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseRegion
implements Region {
    private static final Log log = LogFactory.getLog(BaseRegion.class);
    private final String name;
    protected final CacheAdapter cacheAdapter;
    protected final AddressAdapter address;
    protected final TransactionManager transactionManager;
    protected final boolean replication;
    protected final Object invalidationMutex = new Object();
    protected final AtomicReference<InvalidateState> invalidateState = new AtomicReference<InvalidateState>(InvalidateState.VALID);
    private final RegionFactory factory;

    public BaseRegion(CacheAdapter cacheAdapter, String name, TransactionManager transactionManager, RegionFactory factory) {
        this.cacheAdapter = cacheAdapter;
        this.name = name;
        this.transactionManager = transactionManager;
        this.replication = cacheAdapter.isClusteredReplication();
        this.address = this.cacheAdapter.getAddress();
        this.cacheAdapter.addListener(this);
        this.factory = factory;
    }

    public String getName() {
        return this.name;
    }

    public CacheAdapter getCacheAdapter() {
        return this.cacheAdapter;
    }

    public long getElementCountInMemory() {
        if (this.checkValid()) {
            return this.cacheAdapter.size();
        }
        return 0L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public int getTimeout() {
        return 600;
    }

    public long nextTimestamp() {
        return this.factory.nextTimestamp();
    }

    public Map toMap() {
        if (this.checkValid()) {
            return this.cacheAdapter.toMap();
        }
        return Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws CacheException {
        try {
            this.cacheAdapter.stop();
        }
        finally {
            this.cacheAdapter.removeListener(this);
        }
    }

    public boolean contains(Object key) {
        if (!this.checkValid()) {
            return false;
        }
        return this.cacheAdapter.withFlags(FlagAdapter.ZERO_LOCK_ACQUISITION_TIMEOUT).containsKey(key);
    }

    public AddressAdapter getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValid() {
        boolean valid = this.isValid();
        if (!valid) {
            Object object = this.invalidationMutex;
            synchronized (object) {
                if (this.invalidateState.compareAndSet(InvalidateState.INVALID, InvalidateState.CLEARING)) {
                    Transaction tx = this.suspend();
                    try {
                        this.cacheAdapter.withinTx(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                BaseRegion.this.cacheAdapter.withFlags(FlagAdapter.CACHE_MODE_LOCAL, FlagAdapter.ZERO_LOCK_ACQUISITION_TIMEOUT).clear();
                                return null;
                            }
                        });
                        this.invalidateState.compareAndSet(InvalidateState.CLEARING, InvalidateState.VALID);
                    }
                    catch (Exception e) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Could not invalidate region: " + e.getLocalizedMessage()));
                        }
                    }
                    finally {
                        this.resume(tx);
                    }
                }
            }
            valid = this.isValid();
        }
        return valid;
    }

    protected boolean isValid() {
        return this.invalidateState.get() == InvalidateState.VALID;
    }

    protected Object get(Object key, boolean suppressTimeout, FlagAdapter ... flagAdapters) throws CacheException {
        CacheAdapter localCacheAdapter = this.cacheAdapter;
        if (flagAdapters != null && flagAdapters.length > 0) {
            localCacheAdapter = this.cacheAdapter.withFlags(flagAdapters);
        }
        if (suppressTimeout) {
            return localCacheAdapter.getAllowingTimeout(key);
        }
        return localCacheAdapter.get(key);
    }

    public Object getOwnerForPut() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.getTransaction();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not obtain transaction", (Throwable)se);
        }
        return tx == null ? Thread.currentThread() : tx;
    }

    public Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.suspend();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not suspend transaction", (Throwable)se);
        }
        return tx;
    }

    public void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException("Could not resume transaction", (Throwable)e);
        }
    }

    public void invalidateRegion() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invalidate region: " + this.name));
        }
        this.invalidateState.set(InvalidateState.INVALID);
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    private static enum InvalidateState {
        INVALID,
        CLEARING,
        VALID;

    }
}

