/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.entity;

import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Configuration;
import org.hibernate.test.cache.infinispan.AbstractNonFunctionalTestCase;
import org.hibernate.test.cache.infinispan.NodeEnvironment;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionalExtraAPITestCase
extends AbstractNonFunctionalTestCase {
    public static final String REGION_NAME = "test/com.foo.test";
    public static final String KEY = "KEY";
    public static final String VALUE1 = "VALUE1";
    public static final String VALUE2 = "VALUE2";
    private NodeEnvironment environment;
    private EntityRegionAccessStrategy accessStrategy;

    @Before
    public final void prepareLocalAccessStrategy() throws Exception {
        this.environment = new NodeEnvironment(this.createConfiguration());
        this.environment.prepare();
        this.avoidConcurrentFlush();
        this.accessStrategy = this.environment.getEntityRegion(REGION_NAME, null).buildAccessStrategy(this.getAccessType());
    }

    protected Configuration createConfiguration() {
        Configuration cfg = CacheTestUtil.buildConfiguration("test", InfinispanRegionFactory.class, true, false);
        cfg.setProperty("hibernate.cache.infinispan.entity.cfg", this.getCacheConfigName());
        return cfg;
    }

    @After
    public final void releaseLocalAccessStrategy() throws Exception {
        if (this.environment != null) {
            this.environment.release();
        }
    }

    protected final EntityRegionAccessStrategy getEntityAccessStrategy() {
        return this.accessStrategy;
    }

    protected String getCacheConfigName() {
        return "entity";
    }

    protected AccessType getAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    @Test
    public void testLockItem() {
        Assert.assertNull((Object)this.getEntityAccessStrategy().lockItem((Object)KEY, (Object)1));
    }

    @Test
    public void testLockRegion() {
        Assert.assertNull((Object)this.getEntityAccessStrategy().lockRegion());
    }

    @Test
    public void testUnlockItem() {
        this.getEntityAccessStrategy().unlockItem((Object)KEY, (SoftLock)new MockSoftLock());
    }

    @Test
    public void testUnlockRegion() {
        this.getEntityAccessStrategy().unlockItem((Object)KEY, (SoftLock)new MockSoftLock());
    }

    @Test
    public void testAfterInsert() {
        Assert.assertFalse((String)"afterInsert always returns false", (boolean)this.getEntityAccessStrategy().afterInsert((Object)KEY, (Object)VALUE1, (Object)1));
    }

    @Test
    public void testAfterUpdate() {
        Assert.assertFalse((String)"afterInsert always returns false", (boolean)this.getEntityAccessStrategy().afterUpdate((Object)KEY, (Object)VALUE2, (Object)1, (Object)2, (SoftLock)new MockSoftLock()));
    }

    public static class MockSoftLock
    implements SoftLock {
    }
}

