/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.hibernate.Criteria;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.test.cache.infinispan.functional.AbstractFunctionalTestCase;
import org.hibernate.test.cache.infinispan.functional.Citizen;
import org.hibernate.test.cache.infinispan.functional.Item;
import org.hibernate.test.cache.infinispan.functional.NaturalIdOnManyToOne;
import org.hibernate.test.cache.infinispan.functional.State;
import org.hibernate.test.cache.infinispan.functional.VersionedItem;
import org.infinispan.test.TestingUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class BasicTransactionalTestCase
extends AbstractFunctionalTestCase {
    @Override
    public void configure(Configuration cfg) {
        super.configure(cfg);
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Citizen.class, State.class, NaturalIdOnManyToOne.class};
    }

    @After
    public void cleanupData() throws Exception {
        super.cleanupCache();
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = BasicTransactionalTestCase.this.sessionFactory().openSession();
                s.beginTransaction();
                s.createQuery("delete NaturalIdOnManyToOne").executeUpdate();
                s.createQuery("delete Citizen").executeUpdate();
                s.createQuery("delete State").executeUpdate();
                s.getTransaction().commit();
                s.close();
                return null;
            }
        });
    }

    @Test
    public void testCollectionCache() throws Exception {
        final Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        final Item item = new Item("chris", "Chris's Item");
        final Item another = new Item("another", "Owned Item");
        item.addItem(another);
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = BasicTransactionalTestCase.this.openSession();
                s.getTransaction().begin();
                s.persist((Object)item);
                s.persist((Object)another);
                s.getTransaction().commit();
                s.close();
                return null;
            }
        });
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = BasicTransactionalTestCase.this.openSession();
                Item loaded = (Item)s.load(Item.class, (Serializable)item.getId());
                Assert.assertEquals((long)1L, (long)loaded.getItems().size());
                s.close();
                return null;
            }
        });
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = BasicTransactionalTestCase.this.openSession();
                SecondLevelCacheStatistics cStats = stats.getSecondLevelCacheStatistics(Item.class.getName() + ".items");
                Item loadedWithCachedCollection = (Item)s.load(Item.class, (Serializable)item.getId());
                stats.logSummary();
                Assert.assertEquals((Object)item.getName(), (Object)loadedWithCachedCollection.getName());
                Assert.assertEquals((long)item.getItems().size(), (long)loadedWithCachedCollection.getItems().size());
                Assert.assertEquals((long)1L, (long)cStats.getHitCount());
                Map cacheEntries = cStats.getEntries();
                Assert.assertEquals((long)1L, (long)cacheEntries.size());
                s.close();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStaleWritesLeaveCacheConsistent() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        VersionedItem item = null;
        Transaction txn = null;
        Session s = null;
        this.beginTx();
        try {
            s = this.openSession();
            txn = s.beginTransaction();
            item = new VersionedItem();
            item.setName("steve");
            item.setDescription("steve's item");
            s.save((Object)item);
            txn.commit();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        Long initialVersion = item.getVersion();
        item.setVersion(new Long(item.getVersion() - 1L));
        this.beginTx();
        try {
            s = this.openSession();
            txn = s.beginTransaction();
            s.update((Object)item);
            txn.commit();
            Assert.fail((String)"expected stale write to fail");
        }
        catch (Exception e) {
            this.setRollbackOnlyTxExpected(e);
        }
        finally {
            this.commitOrRollbackTx();
            if (s != null && s.isOpen()) {
                try {
                    s.close();
                }
                catch (Throwable ignore) {}
            }
        }
        SecondLevelCacheStatistics slcs = stats.getSecondLevelCacheStatistics(VersionedItem.class.getName());
        Object entry = slcs.getEntries().get(item.getId());
        Long cachedVersionValue = (Long)((CacheEntry)entry).getVersion();
        Assert.assertEquals((long)initialVersion, (long)cachedVersionValue);
        this.beginTx();
        try {
            s = this.openSession();
            txn = s.beginTransaction();
            item = (VersionedItem)s.load(VersionedItem.class, (Serializable)item.getId());
            s.delete((Object)item);
            txn.commit();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryCacheInvalidation() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics slcs = stats.getSecondLevelCacheStatistics(Item.class.getName());
        this.sessionFactory().getCache().evictEntityRegion(Item.class.getName());
        Assert.assertEquals((long)0L, (long)slcs.getPutCount());
        Assert.assertEquals((long)0L, (long)slcs.getElementCountInMemory());
        Assert.assertEquals((long)0L, (long)slcs.getEntries().size());
        Session s = null;
        Transaction t = null;
        Item i = null;
        this.beginTx();
        try {
            s = this.openSession();
            t = s.beginTransaction();
            i = new Item();
            i.setName("widget");
            i.setDescription("A really top-quality, full-featured widget.");
            s.persist((Object)i);
            t.commit();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        Assert.assertEquals((long)1L, (long)slcs.getPutCount());
        Assert.assertEquals((long)1L, (long)slcs.getElementCountInMemory());
        Assert.assertEquals((long)1L, (long)slcs.getEntries().size());
        this.beginTx();
        try {
            s = this.openSession();
            t = s.beginTransaction();
            i = (Item)s.get(Item.class, (Serializable)i.getId());
            Assert.assertEquals((long)slcs.getHitCount(), (long)1L);
            Assert.assertEquals((long)slcs.getMissCount(), (long)0L);
            i.setDescription("A bog standard item");
            t.commit();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        Assert.assertEquals((long)slcs.getPutCount(), (long)2L);
        CacheEntry entry = (CacheEntry)slcs.getEntries().get(i.getId());
        Serializable[] ser = entry.getDisassembledState();
        Assert.assertTrue((boolean)ser[0].equals("widget"));
        Assert.assertTrue((boolean)ser[1].equals("A bog standard item"));
        this.beginTx();
        try {
            s = this.openSession();
            t = s.beginTransaction();
            s.delete((Object)i);
            t.commit();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryCache() throws Exception {
        Session s;
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("chris", "Chris's Item");
        this.beginTx();
        try {
            s = this.openSession();
            s.getTransaction().begin();
            s.persist((Object)item);
            s.getTransaction().commit();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        Thread.sleep(100L);
        this.beginTx();
        try {
            s = this.openSession();
            s.createQuery("from Item").setCacheable(true).list();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        this.beginTx();
        try {
            s = this.openSession();
            s.createQuery("from Item").setCacheable(true).list();
            Assert.assertEquals((long)1L, (long)stats.getQueryCacheHitCount());
            s.createQuery("delete from Item").executeUpdate();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryCacheHitInSameTransaction() throws Exception {
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        Session s = null;
        Item item = new Item("galder", "Galder's Item");
        this.beginTx();
        try {
            s = this.openSession();
            s.getTransaction().begin();
            s.persist((Object)item);
            s.getTransaction().commit();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        Thread.sleep(100L);
        this.beginTx();
        try {
            s = this.openSession();
            s.createQuery("from Item").setCacheable(true).list();
            s.createQuery("from Item").setCacheable(true).list();
            Assert.assertEquals((long)1L, (long)stats.getQueryCacheHitCount());
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        this.beginTx();
        try {
            s = this.openSession();
            s.createQuery("delete from Item").executeUpdate();
            s.close();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
    }

    @Test
    public void testNaturalIdCached() throws Exception {
        this.saveSomeCitizens();
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = BasicTransactionalTestCase.this.openSession();
                Transaction tx = s.beginTransaction();
                State france = BasicTransactionalTestCase.this.getState(s, "Ile de France");
                Criteria criteria = s.createCriteria(Citizen.class);
                criteria.add((Criterion)Restrictions.naturalId().set("ssn", (Object)"1234").set("state", (Object)france));
                criteria.setCacheable(true);
                BasicTransactionalTestCase.this.cleanupCache();
                Statistics stats = BasicTransactionalTestCase.this.sessionFactory().getStatistics();
                stats.setStatisticsEnabled(true);
                stats.clear();
                Assert.assertEquals((String)"Cache hits should be empty", (long)0L, (long)stats.getNaturalIdCacheHitCount());
                List results = criteria.list();
                Assert.assertEquals((long)1L, (long)results.size());
                Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
                Assert.assertEquals((String)"NaturalId Cache Misses", (long)1L, (long)stats.getNaturalIdCacheMissCount());
                Assert.assertEquals((String)"NaturalId Cache Puts", (long)1L, (long)stats.getNaturalIdCachePutCount());
                Assert.assertEquals((String)"NaturalId Cache Queries", (long)1L, (long)stats.getNaturalIdQueryExecutionCount());
                criteria.list();
                Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
                Assert.assertEquals((String)"NaturalId Cache Misses", (long)1L, (long)stats.getNaturalIdCacheMissCount());
                Assert.assertEquals((String)"NaturalId Cache Puts", (long)1L, (long)stats.getNaturalIdCachePutCount());
                Assert.assertEquals((String)"NaturalId Cache Queries", (long)1L, (long)stats.getNaturalIdQueryExecutionCount());
                tx.rollback();
                s.close();
                return null;
            }
        });
    }

    @Test
    public void testNaturalIdLoaderCached() throws Exception {
        final Statistics stats = this.sessionFactory().getStatistics();
        stats.setStatisticsEnabled(true);
        stats.clear();
        Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
        Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
        Assert.assertEquals((String)"NaturalId Cache Puts", (long)0L, (long)stats.getNaturalIdCachePutCount());
        Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
        this.saveSomeCitizens();
        Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
        Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
        Assert.assertEquals((String)"NaturalId Cache Puts", (long)2L, (long)stats.getNaturalIdCachePutCount());
        Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
        final Citizen citizen = (Citizen)TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Citizen>(){

            @Override
            public Citizen call() throws Exception {
                Session s = BasicTransactionalTestCase.this.openSession();
                Transaction tx = s.beginTransaction();
                State france = BasicTransactionalTestCase.this.getState(s, "Ile de France");
                NaturalIdLoadAccess naturalIdLoader = s.byNaturalId(Citizen.class);
                naturalIdLoader.using("ssn", (Object)"1234").using("state", (Object)france);
                stats.clear();
                Citizen citizen = (Citizen)naturalIdLoader.load();
                junit.framework.Assert.assertNotNull((Object)citizen);
                Assert.assertEquals((String)"NaturalId Cache Hits", (long)1L, (long)stats.getNaturalIdCacheHitCount());
                Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
                Assert.assertEquals((String)"NaturalId Cache Puts", (long)0L, (long)stats.getNaturalIdCachePutCount());
                Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
                tx.rollback();
                s.close();
                return citizen;
            }
        });
        this.cleanupCache();
        Thread.sleep(PutFromLoadValidator.NAKED_PUT_INVALIDATION_PERIOD + TimeUnit.SECONDS.toMillis(1L));
        stats.setStatisticsEnabled(true);
        stats.clear();
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = BasicTransactionalTestCase.this.openSession();
                Transaction tx = s.beginTransaction();
                Citizen loadedCitizen = (Citizen)s.get(Citizen.class, (Serializable)citizen.getId());
                junit.framework.Assert.assertNotNull((Object)loadedCitizen);
                Assert.assertEquals((String)"NaturalId Cache Hits", (long)0L, (long)stats.getNaturalIdCacheHitCount());
                Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
                Assert.assertEquals((String)"NaturalId Cache Puts", (long)1L, (long)stats.getNaturalIdCachePutCount());
                Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
                tx.rollback();
                s.close();
                return null;
            }
        });
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = BasicTransactionalTestCase.this.openSession();
                Transaction tx = s.beginTransaction();
                State france = BasicTransactionalTestCase.this.getState(s, "Ile de France");
                NaturalIdLoadAccess naturalIdLoader = s.byNaturalId(Citizen.class);
                naturalIdLoader.using("ssn", (Object)"1234").using("state", (Object)france);
                stats.setStatisticsEnabled(true);
                stats.clear();
                Citizen loadedCitizen = (Citizen)naturalIdLoader.load();
                junit.framework.Assert.assertNotNull((Object)loadedCitizen);
                Assert.assertEquals((String)"NaturalId Cache Hits", (long)1L, (long)stats.getNaturalIdCacheHitCount());
                Assert.assertEquals((String)"NaturalId Cache Misses", (long)0L, (long)stats.getNaturalIdCacheMissCount());
                Assert.assertEquals((String)"NaturalId Cache Puts", (long)0L, (long)stats.getNaturalIdCachePutCount());
                Assert.assertEquals((String)"NaturalId Cache Queries", (long)0L, (long)stats.getNaturalIdQueryExecutionCount());
                tx.rollback();
                s.close();
                return null;
            }
        });
    }

    private void saveSomeCitizens() throws Exception {
        final Citizen c1 = new Citizen();
        c1.setFirstname("Emmanuel");
        c1.setLastname("Bernard");
        c1.setSsn("1234");
        final State france = new State();
        france.setName("Ile de France");
        c1.setState(france);
        final Citizen c2 = new Citizen();
        c2.setFirstname("Gavin");
        c2.setLastname("King");
        c2.setSsn("000");
        final State australia = new State();
        australia.setName("Australia");
        c2.setState(australia);
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = BasicTransactionalTestCase.this.openSession();
                Transaction tx = s.beginTransaction();
                s.persist((Object)australia);
                s.persist((Object)france);
                s.persist((Object)c1);
                s.persist((Object)c2);
                tx.commit();
                s.close();
                return null;
            }
        });
    }

    private State getState(Session s, String name) {
        Criteria criteria = s.createCriteria(State.class);
        criteria.add(Restrictions.eq((String)"name", (Object)name));
        criteria.setCacheable(true);
        return (State)criteria.list().get(0);
    }
}

