/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.cache.spi.RegionFactory;
import org.infinispan.Cache;
import org.jboss.logging.Logger;

public class CacheTestSupport {
    private static final Logger log = Logger.getLogger(CacheTestSupport.class);
    private static final String PREFER_IPV4STACK = "java.net.preferIPv4Stack";
    private Set<Cache> caches = new HashSet<Cache>();
    private Set<RegionFactory> factories = new HashSet<RegionFactory>();
    private Exception exception;
    private String preferIPv4Stack;

    public void registerCache(Cache cache) {
        this.caches.add(cache);
    }

    public void registerFactory(RegionFactory factory) {
        this.factories.add(factory);
    }

    public void unregisterCache(Cache cache) {
        this.caches.remove(cache);
    }

    public void unregisterFactory(RegionFactory factory) {
        this.factories.remove(factory);
    }

    public void setUp() throws Exception {
        this.preferIPv4Stack = System.getProperty(PREFER_IPV4STACK);
        System.setProperty(PREFER_IPV4STACK, "true");
        this.cleanUp();
        this.throwStoredException();
    }

    public void tearDown() throws Exception {
        if (this.preferIPv4Stack == null) {
            System.clearProperty(PREFER_IPV4STACK);
        } else {
            System.setProperty(PREFER_IPV4STACK, this.preferIPv4Stack);
        }
        this.cleanUp();
        this.throwStoredException();
    }

    public void avoidConcurrentFlush() {
        this.sleep(100L);
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Interrupted during sleep", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        Iterator<RegionFactory> it = this.factories.iterator();
        while (it.hasNext()) {
            try {
                it.next().stop();
            }
            catch (Exception e) {
                this.storeException(e);
            }
            finally {
                it.remove();
            }
        }
        this.factories.clear();
        it = this.caches.iterator();
        while (it.hasNext()) {
            try {
                Cache cache = (Cache)it.next();
                cache.stop();
            }
            catch (Exception e) {
                this.storeException(e);
            }
            finally {
                it.remove();
            }
            this.avoidConcurrentFlush();
        }
        this.caches.clear();
    }

    private void storeException(Exception e) {
        if (this.exception == null) {
            this.exception = e;
        }
    }

    private void throwStoredException() throws Exception {
        if (this.exception != null) {
            Exception toThrow = this.exception;
            this.exception = null;
            throw toThrow;
        }
    }
}

