/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.collection;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import junit.framework.AssertionFailedError;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.access.TransactionalAccessDelegate;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.test.cache.infinispan.AbstractNonFunctionalTestCase;
import org.hibernate.test.cache.infinispan.NodeEnvironment;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.infinispan.AdvancedCache;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCollectionRegionAccessStrategyTestCase
extends AbstractNonFunctionalTestCase {
    private static final Logger log = Logger.getLogger(AbstractCollectionRegionAccessStrategyTestCase.class);
    public static final String REGION_NAME = "test/com.foo.test";
    public static final String KEY_BASE = "KEY";
    public static final String VALUE1 = "VALUE1";
    public static final String VALUE2 = "VALUE2";
    protected static int testCount;
    protected NodeEnvironment localEnvironment;
    protected CollectionRegionImpl localCollectionRegion;
    protected CollectionRegionAccessStrategy localAccessStrategy;
    protected NodeEnvironment remoteEnvironment;
    protected CollectionRegionImpl remoteCollectionRegion;
    protected CollectionRegionAccessStrategy remoteAccessStrategy;
    protected boolean invalidation;
    protected boolean synchronous;
    protected Exception node1Exception;
    protected Exception node2Exception;
    protected AssertionFailedError node1Failure;
    protected AssertionFailedError node2Failure;

    protected abstract AccessType getAccessType();

    @Before
    public void prepareResources() throws Exception {
        Configuration cfg = AbstractCollectionRegionAccessStrategyTestCase.createConfiguration(this.getConfigurationName());
        this.localEnvironment = new NodeEnvironment(cfg);
        this.localEnvironment.prepare();
        this.localCollectionRegion = this.localEnvironment.getCollectionRegion(REGION_NAME, this.getCacheDataDescription());
        this.localAccessStrategy = this.localCollectionRegion.buildAccessStrategy(this.getAccessType());
        this.invalidation = Caches.isInvalidationCache((AdvancedCache)this.localCollectionRegion.getCache());
        this.synchronous = Caches.isSynchronousCache((AdvancedCache)this.localCollectionRegion.getCache());
        this.avoidConcurrentFlush();
        this.remoteEnvironment = new NodeEnvironment(cfg);
        this.remoteEnvironment.prepare();
        this.remoteCollectionRegion = this.remoteEnvironment.getCollectionRegion(REGION_NAME, this.getCacheDataDescription());
        this.remoteAccessStrategy = this.remoteCollectionRegion.buildAccessStrategy(this.getAccessType());
    }

    protected abstract String getConfigurationName();

    protected static Configuration createConfiguration(String configName) {
        Configuration cfg = CacheTestUtil.buildConfiguration("test", InfinispanRegionFactory.class, true, false);
        cfg.setProperty("hibernate.cache.infinispan.entity.cfg", configName);
        return cfg;
    }

    protected CacheDataDescription getCacheDataDescription() {
        return new CacheDataDescriptionImpl(true, true, ComparableComparator.INSTANCE);
    }

    @After
    public void releaseResources() throws Exception {
        if (this.localEnvironment != null) {
            this.localEnvironment.release();
        }
        if (this.remoteEnvironment != null) {
            this.remoteEnvironment.release();
        }
    }

    protected boolean isUsingInvalidation() {
        return this.invalidation;
    }

    protected boolean isSynchronous() {
        return this.synchronous;
    }

    @Test
    public abstract void testCacheConfiguration();

    @Test
    public void testGetRegion() {
        Assert.assertEquals((String)"Correct region", (Object)this.localCollectionRegion, (Object)this.localAccessStrategy.getRegion());
    }

    @Test
    public void testPutFromLoadRemoveDoesNotProduceStaleData() throws Exception {
        final CountDownLatch pferLatch = new CountDownLatch(1);
        final CountDownLatch removeLatch = new CountDownLatch(1);
        final TransactionManager remoteTm = this.remoteCollectionRegion.getTransactionManager();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            public void call() {
                PutFromLoadValidator validator = new PutFromLoadValidator(this.cm, remoteTm, 20000L){

                    public boolean acquirePutFromLoadLock(Object key) {
                        boolean acquired = super.acquirePutFromLoadLock(key);
                        try {
                            removeLatch.countDown();
                            pferLatch.await(2L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            log.debug((Object)"Interrupted");
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            log.error((Object)"Error", (Throwable)e);
                            throw new RuntimeException("Error", e);
                        }
                        return acquired;
                    }
                };
                final TransactionalAccessDelegate delegate = new TransactionalAccessDelegate((BaseRegion)AbstractCollectionRegionAccessStrategyTestCase.this.localCollectionRegion, validator);
                final TransactionManager localTm = AbstractCollectionRegionAccessStrategyTestCase.this.localCollectionRegion.getTransactionManager();
                Callable<Void> pferCallable = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        delegate.putFromLoad((Object)"k1", (Object)"v1", 0L, null);
                        return null;
                    }
                };
                Callable<Void> removeCallable = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        removeLatch.await();
                        Caches.withinTx((TransactionManager)localTm, (Callable)new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                delegate.remove((Object)"k1");
                                return null;
                            }
                        });
                        pferLatch.countDown();
                        return null;
                    }
                };
                ExecutorService executorService = Executors.newCachedThreadPool();
                Future<Void> pferFuture = executorService.submit(pferCallable);
                Future<Void> removeFuture = executorService.submit(removeCallable);
                try {
                    pferFuture.get();
                    removeFuture.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Assert.assertFalse((boolean)AbstractCollectionRegionAccessStrategyTestCase.this.localCollectionRegion.getCache().containsKey((Object)"k1"));
            }
        });
    }

    @Test
    public void testPutFromLoad() throws Exception {
        this.putFromLoadTest(false);
    }

    @Test
    public void testPutFromLoadMinimal() throws Exception {
        this.putFromLoadTest(true);
    }

    private void putFromLoadTest(final boolean useMinimalAPI) throws Exception {
        final String KEY = KEY_BASE + testCount++;
        final CountDownLatch writeLatch1 = new CountDownLatch(1);
        final CountDownLatch writeLatch2 = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(2);
        Thread node1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    Assert.assertEquals((String)"node1 starts clean", null, (Object)AbstractCollectionRegionAccessStrategyTestCase.this.localAccessStrategy.get((Object)KEY, txTimestamp));
                    writeLatch1.await();
                    if (useMinimalAPI) {
                        AbstractCollectionRegionAccessStrategyTestCase.this.localAccessStrategy.putFromLoad((Object)KEY, (Object)AbstractCollectionRegionAccessStrategyTestCase.VALUE2, txTimestamp, (Object)new Integer(2), true);
                    } else {
                        AbstractCollectionRegionAccessStrategyTestCase.this.localAccessStrategy.putFromLoad((Object)KEY, (Object)AbstractCollectionRegionAccessStrategyTestCase.VALUE2, txTimestamp, (Object)new Integer(2));
                    }
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node1 caught exception", (Throwable)e);
                    AbstractCollectionRegionAccessStrategyTestCase.this.node1Exception = e;
                    AbstractCollectionRegionAccessStrategyTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractCollectionRegionAccessStrategyTestCase.this.node1Failure = e;
                    AbstractCollectionRegionAccessStrategyTestCase.this.rollback();
                }
                finally {
                    writeLatch2.countDown();
                    completionLatch.countDown();
                }
            }
        };
        Thread node2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    Assert.assertNull((String)"node2 starts clean", (Object)AbstractCollectionRegionAccessStrategyTestCase.this.remoteAccessStrategy.get((Object)KEY, txTimestamp));
                    writeLatch1.countDown();
                    writeLatch2.await();
                    3.sleep(200L);
                    if (useMinimalAPI) {
                        AbstractCollectionRegionAccessStrategyTestCase.this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)AbstractCollectionRegionAccessStrategyTestCase.VALUE1, txTimestamp, (Object)new Integer(1), true);
                    } else {
                        AbstractCollectionRegionAccessStrategyTestCase.this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)AbstractCollectionRegionAccessStrategyTestCase.VALUE1, txTimestamp, (Object)new Integer(1));
                    }
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node2 caught exception", (Throwable)e);
                    AbstractCollectionRegionAccessStrategyTestCase.this.node2Exception = e;
                    AbstractCollectionRegionAccessStrategyTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractCollectionRegionAccessStrategyTestCase.this.node2Failure = e;
                    AbstractCollectionRegionAccessStrategyTestCase.this.rollback();
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        node1.setDaemon(true);
        node2.setDaemon(true);
        node1.start();
        node2.start();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(2L, TimeUnit.SECONDS));
        if (this.node1Failure != null) {
            throw this.node1Failure;
        }
        if (this.node2Failure != null) {
            throw this.node2Failure;
        }
        Assert.assertEquals((String)"node1 saw no exceptions", null, (Object)this.node1Exception);
        Assert.assertEquals((String)"node2 saw no exceptions", null, (Object)this.node2Exception);
        this.sleep(100L);
        long txTimestamp = System.currentTimeMillis();
        String msg1 = "Correct node1 value";
        String msg2 = "Correct node2 value";
        String expected1 = null;
        String expected2 = null;
        if (this.isUsingInvalidation()) {
            expected1 = VALUE2;
            expected2 = VALUE1;
        } else {
            expected1 = VALUE2;
            expected2 = VALUE2;
        }
        Assert.assertEquals((String)msg1, (Object)expected1, (Object)this.localAccessStrategy.get((Object)KEY, txTimestamp));
        Assert.assertEquals((String)msg2, (Object)expected2, (Object)this.remoteAccessStrategy.get((Object)KEY, txTimestamp));
    }

    @Test
    public void testRemove() throws Exception {
        this.evictOrRemoveTest(false);
    }

    @Test
    public void testRemoveAll() throws Exception {
        this.evictOrRemoveAllTest(false);
    }

    @Test
    public void testEvict() throws Exception {
        this.evictOrRemoveTest(true);
    }

    @Test
    public void testEvictAll() throws Exception {
        this.evictOrRemoveAllTest(true);
    }

    private void evictOrRemoveTest(final boolean evict) throws Exception {
        final String KEY = KEY_BASE + testCount++;
        Assert.assertNull((String)"local is clean", (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertNull((String)"remote is clean", (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.localAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.sleep(250L);
        Caches.withinTx((TransactionManager)this.localCollectionRegion.getTransactionManager(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (evict) {
                    AbstractCollectionRegionAccessStrategyTestCase.this.localAccessStrategy.evict((Object)KEY);
                } else {
                    AbstractCollectionRegionAccessStrategyTestCase.this.localAccessStrategy.remove((Object)KEY);
                }
                return null;
            }
        });
        Assert.assertEquals(null, (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals(null, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
    }

    private void evictOrRemoveAllTest(final boolean evict) throws Exception {
        String KEY = KEY_BASE + testCount++;
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.localCollectionRegion.getCache().keySet()));
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.remoteCollectionRegion.getCache().keySet()));
        Assert.assertNull((String)"local is clean", (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertNull((String)"remote is clean", (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.localAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.sleep(250L);
        Caches.withinTx((TransactionManager)this.localCollectionRegion.getTransactionManager(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (evict) {
                    AbstractCollectionRegionAccessStrategyTestCase.this.localAccessStrategy.evictAll();
                } else {
                    AbstractCollectionRegionAccessStrategyTestCase.this.localAccessStrategy.removeAll();
                }
                return null;
            }
        });
        Assert.assertNull((Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.localCollectionRegion.getCache().keySet()));
        Assert.assertEquals(null, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.remoteCollectionRegion.getCache().keySet()));
        this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((long)1L, (long)this.getValidKeyCount(this.remoteCollectionRegion.getCache().keySet()));
        this.sleep(250L);
        Assert.assertEquals((String)"local is correct", (Object)(this.isUsingInvalidation() ? null : VALUE1), (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((String)"remote is correct", (Object)VALUE1, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
    }

    private void rollback() {
        try {
            BatchModeTransactionManager.getInstance().rollback();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

