/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.access;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.TransactionManager;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PutFromLoadValidatorUnitTestCase {
    private static final Log log = LogFactory.getLog(PutFromLoadValidatorUnitTestCase.class);
    private Object KEY1 = "KEY1";
    private TransactionManager tm;

    @Before
    public void setUp() throws Exception {
        this.tm = DualNodeJtaTransactionManagerImpl.getInstance("test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        this.tm = null;
        try {
            DualNodeJtaTransactionManagerImpl.cleanupTransactions();
        }
        finally {
            DualNodeJtaTransactionManagerImpl.cleanupTransactionManagers();
        }
    }

    @Test
    public void testNakedPut() throws Exception {
        this.nakedPutTest(false);
    }

    @Test
    public void testNakedPutTransactional() throws Exception {
        this.nakedPutTest(true);
    }

    private void nakedPutTest(final boolean transactional) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                try {
                    PutFromLoadValidator testee = new PutFromLoadValidator(this.cm, transactional ? PutFromLoadValidatorUnitTestCase.this.tm : null, PutFromLoadValidator.NAKED_PUT_INVALIDATION_PERIOD);
                    if (transactional) {
                        PutFromLoadValidatorUnitTestCase.this.tm.begin();
                    }
                    boolean lockable = testee.acquirePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    try {
                        Assert.assertTrue((boolean)lockable);
                    }
                    finally {
                        if (lockable) {
                            testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testRegisteredPut() throws Exception {
        this.registeredPutTest(false);
    }

    @Test
    public void testRegisteredPutTransactional() throws Exception {
        this.registeredPutTest(true);
    }

    private void registeredPutTest(final boolean transactional) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                PutFromLoadValidator testee = new PutFromLoadValidator(this.cm, transactional ? PutFromLoadValidatorUnitTestCase.this.tm : null, PutFromLoadValidator.NAKED_PUT_INVALIDATION_PERIOD);
                try {
                    if (transactional) {
                        PutFromLoadValidatorUnitTestCase.this.tm.begin();
                    }
                    testee.registerPendingPut(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    boolean lockable = testee.acquirePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    try {
                        Assert.assertTrue((boolean)lockable);
                    }
                    finally {
                        if (lockable) {
                            testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testNakedPutAfterKeyRemoval() throws Exception {
        this.nakedPutAfterRemovalTest(false, false);
    }

    @Test
    public void testNakedPutAfterKeyRemovalTransactional() throws Exception {
        this.nakedPutAfterRemovalTest(true, false);
    }

    @Test
    public void testNakedPutAfterRegionRemoval() throws Exception {
        this.nakedPutAfterRemovalTest(false, true);
    }

    @Test
    public void testNakedPutAfterRegionRemovalTransactional() throws Exception {
        this.nakedPutAfterRemovalTest(true, true);
    }

    private void nakedPutAfterRemovalTest(final boolean transactional, final boolean removeRegion) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                PutFromLoadValidator testee = new PutFromLoadValidator(this.cm, transactional ? PutFromLoadValidatorUnitTestCase.this.tm : null, PutFromLoadValidator.NAKED_PUT_INVALIDATION_PERIOD);
                if (removeRegion) {
                    testee.invalidateRegion();
                } else {
                    testee.invalidateKey(PutFromLoadValidatorUnitTestCase.this.KEY1);
                }
                try {
                    if (transactional) {
                        PutFromLoadValidatorUnitTestCase.this.tm.begin();
                    }
                    boolean lockable = testee.acquirePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    try {
                        Assert.assertFalse((boolean)lockable);
                    }
                    finally {
                        if (lockable) {
                            testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testRegisteredPutAfterKeyRemoval() throws Exception {
        this.registeredPutAfterRemovalTest(false, false);
    }

    @Test
    public void testRegisteredPutAfterKeyRemovalTransactional() throws Exception {
        this.registeredPutAfterRemovalTest(true, false);
    }

    @Test
    public void testRegisteredPutAfterRegionRemoval() throws Exception {
        this.registeredPutAfterRemovalTest(false, true);
    }

    @Test
    public void testRegisteredPutAfterRegionRemovalTransactional() throws Exception {
        this.registeredPutAfterRemovalTest(true, true);
    }

    private void registeredPutAfterRemovalTest(final boolean transactional, final boolean removeRegion) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                PutFromLoadValidator testee = new PutFromLoadValidator(this.cm, transactional ? PutFromLoadValidatorUnitTestCase.this.tm : null, PutFromLoadValidator.NAKED_PUT_INVALIDATION_PERIOD);
                if (removeRegion) {
                    testee.invalidateRegion();
                } else {
                    testee.invalidateKey(PutFromLoadValidatorUnitTestCase.this.KEY1);
                }
                try {
                    if (transactional) {
                        PutFromLoadValidatorUnitTestCase.this.tm.begin();
                    }
                    testee.registerPendingPut(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    boolean lockable = testee.acquirePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    try {
                        Assert.assertTrue((boolean)lockable);
                    }
                    finally {
                        if (lockable) {
                            testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testRegisteredPutWithInterveningKeyRemoval() throws Exception {
        this.registeredPutWithInterveningRemovalTest(false, false);
    }

    @Test
    public void testRegisteredPutWithInterveningKeyRemovalTransactional() throws Exception {
        this.registeredPutWithInterveningRemovalTest(true, false);
    }

    @Test
    public void testRegisteredPutWithInterveningRegionRemoval() throws Exception {
        this.registeredPutWithInterveningRemovalTest(false, true);
    }

    @Test
    public void testRegisteredPutWithInterveningRegionRemovalTransactional() throws Exception {
        this.registeredPutWithInterveningRemovalTest(true, true);
    }

    private void registeredPutWithInterveningRemovalTest(final boolean transactional, final boolean removeRegion) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                PutFromLoadValidator testee = new PutFromLoadValidator(this.cm, transactional ? PutFromLoadValidatorUnitTestCase.this.tm : null, PutFromLoadValidator.NAKED_PUT_INVALIDATION_PERIOD);
                try {
                    if (transactional) {
                        PutFromLoadValidatorUnitTestCase.this.tm.begin();
                    }
                    testee.registerPendingPut(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    if (removeRegion) {
                        testee.invalidateRegion();
                    } else {
                        testee.invalidateKey(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    }
                    boolean lockable = testee.acquirePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    try {
                        Assert.assertFalse((boolean)lockable);
                    }
                    finally {
                        if (lockable) {
                            testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testDelayedNakedPutAfterKeyRemoval() throws Exception {
        this.delayedNakedPutAfterRemovalTest(false, false);
    }

    @Test
    public void testDelayedNakedPutAfterKeyRemovalTransactional() throws Exception {
        this.delayedNakedPutAfterRemovalTest(true, false);
    }

    @Test
    public void testDelayedNakedPutAfterRegionRemoval() throws Exception {
        this.delayedNakedPutAfterRemovalTest(false, true);
    }

    @Test
    public void testDelayedNakedPutAfterRegionRemovalTransactional() throws Exception {
        this.delayedNakedPutAfterRemovalTest(true, true);
    }

    private void delayedNakedPutAfterRemovalTest(final boolean transactional, final boolean removeRegion) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                TestValidator testee = new TestValidator(this.cm, transactional ? PutFromLoadValidatorUnitTestCase.this.tm : null, 100L);
                if (removeRegion) {
                    testee.invalidateRegion();
                } else {
                    testee.invalidateKey(PutFromLoadValidatorUnitTestCase.this.KEY1);
                }
                try {
                    if (transactional) {
                        PutFromLoadValidatorUnitTestCase.this.tm.begin();
                    }
                    Thread.sleep(110L);
                    boolean lockable = testee.acquirePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                    try {
                        Assert.assertTrue((boolean)lockable);
                    }
                    finally {
                        if (lockable) {
                            testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testMultipleRegistrations() throws Exception {
        this.multipleRegistrationtest(false);
    }

    @Test
    public void testMultipleRegistrationsTransactional() throws Exception {
        this.multipleRegistrationtest(true);
    }

    private void multipleRegistrationtest(final boolean transactional) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            public void call() {
                final PutFromLoadValidator testee = new PutFromLoadValidator(this.cm, transactional ? PutFromLoadValidatorUnitTestCase.this.tm : null, PutFromLoadValidator.NAKED_PUT_INVALIDATION_PERIOD);
                final CountDownLatch registeredLatch = new CountDownLatch(3);
                final CountDownLatch finishedLatch = new CountDownLatch(3);
                final AtomicInteger success = new AtomicInteger();
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (transactional) {
                                PutFromLoadValidatorUnitTestCase.this.tm.begin();
                            }
                            testee.registerPendingPut(PutFromLoadValidatorUnitTestCase.this.KEY1);
                            registeredLatch.countDown();
                            registeredLatch.await(5L, TimeUnit.SECONDS);
                            if (testee.acquirePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1)) {
                                try {
                                    log.trace((Object)("Put from load lock acquired for key = " + PutFromLoadValidatorUnitTestCase.this.KEY1));
                                    success.incrementAndGet();
                                }
                                finally {
                                    testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                                }
                            } else {
                                log.trace((Object)("Unable to acquired putFromLoad lock for key = " + PutFromLoadValidatorUnitTestCase.this.KEY1));
                            }
                            finishedLatch.countDown();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                ExecutorService executor = Executors.newFixedThreadPool(3);
                testee.invalidateRegion();
                executor.execute(r);
                executor.execute(r);
                executor.execute(r);
                try {
                    finishedLatch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertEquals((String)"All threads succeeded", (long)3L, (long)success.get());
            }
        });
    }

    @Test
    public void testRemovalCleanup() throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            public void call() {
                TestValidator testee = new TestValidator(this.cm, null, 200L);
                testee.invalidateKey("KEY1");
                testee.invalidateKey("KEY2");
                PutFromLoadValidatorUnitTestCase.this.expectRemovalLenth(2, testee, 60000L);
                Assert.assertEquals((long)2L, (long)testee.getRemovalQueueLength());
                PutFromLoadValidatorUnitTestCase.this.expectRemovalLenth(2, testee, 60000L);
                Assert.assertEquals((long)2L, (long)testee.getRemovalQueueLength());
                PutFromLoadValidatorUnitTestCase.this.expectRemovalLenth(2, testee, 60000L);
            }
        });
    }

    private void expectRemovalLenth(int expectedLength, TestValidator testee, long timeout) {
        long timeoutMilestone = System.currentTimeMillis() + timeout;
        int queueLength;
        while ((queueLength = testee.getRemovalQueueLength()) != expectedLength) {
            if (System.currentTimeMillis() > timeoutMilestone) {
                Assert.fail((String)("condition not reached after " + timeout + " milliseconds. giving up!"));
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return;
    }

    @Test
    public void testInvalidateKeyBlocksForInProgressPut() throws Exception {
        this.invalidationBlocksForInProgressPutTest(true);
    }

    @Test
    public void testInvalidateRegionBlocksForInProgressPut() throws Exception {
        this.invalidationBlocksForInProgressPutTest(false);
    }

    private void invalidationBlocksForInProgressPutTest(final boolean keyOnly) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((boolean)false)){

            public void call() {
                final PutFromLoadValidator testee = new PutFromLoadValidator(this.cm, null, PutFromLoadValidator.NAKED_PUT_INVALIDATION_PERIOD);
                final CountDownLatch removeLatch = new CountDownLatch(1);
                final CountDownLatch pferLatch = new CountDownLatch(1);
                final AtomicReference<String> cache = new AtomicReference<String>("INITIAL");
                Callable<Boolean> pferCallable = new Callable<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean call() throws Exception {
                        testee.registerPendingPut(PutFromLoadValidatorUnitTestCase.this.KEY1);
                        if (testee.acquirePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1)) {
                            try {
                                removeLatch.countDown();
                                pferLatch.await();
                                cache.set("PFER");
                                Boolean bl = Boolean.TRUE;
                                return bl;
                            }
                            finally {
                                testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTestCase.this.KEY1);
                            }
                        }
                        return Boolean.FALSE;
                    }
                };
                Callable<Void> invalidateCallable = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        removeLatch.await();
                        if (keyOnly) {
                            testee.invalidateKey(PutFromLoadValidatorUnitTestCase.this.KEY1);
                        } else {
                            testee.invalidateRegion();
                        }
                        cache.set(null);
                        return null;
                    }
                };
                ExecutorService executorService = Executors.newCachedThreadPool();
                Future<Boolean> pferFuture = executorService.submit(pferCallable);
                Future<Void> invalidateFuture = executorService.submit(invalidateCallable);
                try {
                    try {
                        invalidateFuture.get(1L, TimeUnit.SECONDS);
                        Assert.fail((String)"invalidateFuture did not block");
                    }
                    catch (TimeoutException good) {
                        // empty catch block
                    }
                    pferLatch.countDown();
                    Assert.assertTrue((boolean)pferFuture.get(5L, TimeUnit.SECONDS));
                    invalidateFuture.get(5L, TimeUnit.SECONDS);
                    Assert.assertNull((Object)cache.get());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testGetForNullReleasePuts() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((boolean)false);
        ConfigurationBuilder cb = new ConfigurationBuilder().read(InfinispanRegionFactory.PENDING_PUTS_CACHE_CONFIGURATION);
        cb.expiration().maxIdle(500L);
        cm.defineConfiguration("pending-puts", cb.build());
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(cm){

            public void call() {
                int size;
                final PutFromLoadValidator testee = new PutFromLoadValidator(this.cm.getCache().getAdvancedCache());
                long lastInsert = Long.MAX_VALUE;
                for (int i = 0; i < 100; ++i) {
                    lastInsert = System.currentTimeMillis();
                    try {
                        TestingUtil.withTx((TransactionManager)PutFromLoadValidatorUnitTestCase.this.tm, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                testee.registerPendingPut(PutFromLoadValidatorUnitTestCase.this.KEY1);
                                return null;
                            }
                        });
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                String ppName = "pending-puts";
                Cache ppCache = this.cm.getCache(ppName, false);
                Assert.assertNotNull((Object)ppCache);
                Object pendingPutMap = ppCache.get(PutFromLoadValidatorUnitTestCase.this.KEY1);
                long end = System.currentTimeMillis();
                if (end - lastInsert > 500L) {
                    log.warn((Object)"Test took too long");
                    return;
                }
                Assert.assertNotNull(pendingPutMap);
                try {
                    Method sizeMethod = pendingPutMap.getClass().getMethod("size", new Class[0]);
                    sizeMethod.setAccessible(true);
                    size = (Integer)sizeMethod.invoke(pendingPutMap, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Assert.assertTrue((size < 100 ? 1 : 0) != 0);
                Assert.assertTrue((size > 0 ? 1 : 0) != 0);
            }
        });
    }

    private static class TestValidator
    extends PutFromLoadValidator {
        protected TestValidator(EmbeddedCacheManager cm, TransactionManager transactionManager, long nakedPutInvalidationPeriod) {
            super(cm, transactionManager, nakedPutInvalidationPeriod);
        }

        public int getRemovalQueueLength() {
            return super.getRemovalQueueLength();
        }
    }
}

