/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.util.BeginInvalidationCommand;
import org.hibernate.cache.infinispan.util.CacheCommandInitializer;
import org.hibernate.cache.infinispan.util.EndInvalidationCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;

public class NonTxPutFromLoadInterceptor
extends BaseCustomInterceptor {
    private final String cacheName;
    private final PutFromLoadValidator putFromLoadValidator;
    private CacheCommandInitializer commandInitializer;
    private RpcManager rpcManager;

    public NonTxPutFromLoadInterceptor(PutFromLoadValidator putFromLoadValidator, String cacheName) {
        this.putFromLoadValidator = putFromLoadValidator;
        this.cacheName = cacheName;
    }

    @Inject
    public void injectDependencies(CacheCommandInitializer commandInitializer, RpcManager rpcManager) {
        this.commandInitializer = commandInitializer;
        this.rpcManager = rpcManager;
    }

    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (!ctx.isOriginLocal() && command instanceof BeginInvalidationCommand) {
            for (Object key : command.getKeys()) {
                this.putFromLoadValidator.beginInvalidatingKey(((BeginInvalidationCommand)command).getLockOwner(), key);
            }
        }
        return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    public void broadcastEndInvalidationCommand(Object[] keys, Object lockOwner) {
        assert (lockOwner != null);
        EndInvalidationCommand endInvalidationCommand = this.commandInitializer.buildEndInvalidationCommand(this.cacheName, keys, lockOwner);
        this.rpcManager.invokeRemotely(null, (ReplicableCommand)endInvalidationCommand, this.rpcManager.getDefaultRpcOptions(false, DeliverOrder.NONE));
    }
}

