/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.access.TransactionalAccessDelegate;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class NonTxTransactionalAccessDelegate
extends TransactionalAccessDelegate {
    public NonTxTransactionalAccessDelegate(BaseRegion region, PutFromLoadValidator validator) {
        super(region, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        if (!this.putValidator.beginInvalidatingWithPFER(session, key, value)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.remove(key);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        if (!this.putValidator.beginInvalidatingWithPFER(session, key, value)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.remove(key);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }

    @Override
    public void unlockItem(SessionImplementor session, Object key) throws CacheException {
        boolean doPFER;
        TransactionCoordinator tc = session.getTransactionCoordinator();
        boolean bl = doPFER = tc != null && tc.getTransactionDriverControl().getStatus() == TransactionStatus.COMMITTED;
        if (!this.putValidator.endInvalidatingKey(session, key, doPFER)) {
            log.warn((Object)("Failed to end invalidating pending putFromLoad calls for key " + key + " from region " + this.region.getName() + "; the key won't be cached until invalidation expires."));
        }
    }
}

