/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.xml.validation.Schema;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.FileTimeStampChecker;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.util.xml.XmlParserHelper;
import org.hibernate.jpamodelgen.util.xml.XmlParsingException;
import org.hibernate.jpamodelgen.xml.XmlMetaEntity;
import org.hibernate.jpamodelgen.xml.jaxb.AccessType;
import org.hibernate.jpamodelgen.xml.jaxb.Embeddable;
import org.hibernate.jpamodelgen.xml.jaxb.Entity;
import org.hibernate.jpamodelgen.xml.jaxb.EntityMappings;
import org.hibernate.jpamodelgen.xml.jaxb.MappedSuperclass;
import org.hibernate.jpamodelgen.xml.jaxb.Persistence;
import org.hibernate.jpamodelgen.xml.jaxb.PersistenceUnitDefaults;
import org.hibernate.jpamodelgen.xml.jaxb.PersistenceUnitMetadata;

public class JpaDescriptorParser {
    private static final String DEFAULT_ORM_XML_LOCATION = "/META-INF/orm.xml";
    private static final String SERIALIZATION_FILE_NAME = "Hibernate-Static-Metamodel-Generator.tmp";
    private static final String PERSISTENCE_SCHEMA = "persistence_2_1.xsd";
    private static final String ORM_SCHEMA = "orm_2_1.xsd";
    private final Context context;
    private final List<EntityMappings> entityMappings;
    private final XmlParserHelper xmlParserHelper;

    public JpaDescriptorParser(Context context) {
        this.context = context;
        this.entityMappings = new ArrayList<EntityMappings>();
        this.xmlParserHelper = new XmlParserHelper(context);
    }

    public void parseXml() {
        Collection<String> mappingFileNames = this.determineMappingFileNames();
        if (this.context.doLazyXmlParsing() && this.mappingFilesUnchanged(mappingFileNames)) {
            return;
        }
        this.loadEntityMappings(mappingFileNames);
        this.determineDefaultAccessTypeAndMetaCompleteness();
        this.determineXmlAccessTypes();
        if (!this.context.isFullyXmlConfigured()) {
            this.determineAnnotationAccessTypes();
        }
        for (EntityMappings mappings : this.entityMappings) {
            String defaultPackageName = mappings.getPackage();
            this.parseEntities(mappings.getEntity(), defaultPackageName);
            this.parseEmbeddable(mappings.getEmbeddable(), defaultPackageName);
            this.parseMappedSuperClass(mappings.getMappedSuperclass(), defaultPackageName);
        }
    }

    private Collection<String> determineMappingFileNames() {
        ArrayList<String> mappingFileNames = new ArrayList<String>();
        Persistence persistence = this.getPersistence();
        if (persistence != null) {
            List<Persistence.PersistenceUnit> persistenceUnits = persistence.getPersistenceUnit();
            for (Persistence.PersistenceUnit unit : persistenceUnits) {
                mappingFileNames.addAll(unit.getMappingFile());
            }
        }
        mappingFileNames.add(DEFAULT_ORM_XML_LOCATION);
        mappingFileNames.addAll(this.context.getOrmXmlFiles());
        return mappingFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Persistence getPersistence() {
        Persistence persistence = null;
        String persistenceXmlLocation = this.context.getPersistenceXmlLocation();
        InputStream stream = this.xmlParserHelper.getInputStreamForResource(persistenceXmlLocation);
        if (stream == null) {
            return null;
        }
        try {
            Schema schema = this.xmlParserHelper.getSchema(PERSISTENCE_SCHEMA);
            persistence = this.xmlParserHelper.getJaxbRoot(stream, Persistence.class, schema);
        }
        catch (XmlParsingException e) {
            this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to parse persistence.xml: " + e.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return persistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntityMappings(Collection<String> mappingFileNames) {
        for (String mappingFile : mappingFileNames) {
            InputStream stream = this.xmlParserHelper.getInputStreamForResource(mappingFile);
            if (stream == null) continue;
            try {
                Schema schema = this.xmlParserHelper.getSchema(ORM_SCHEMA);
                EntityMappings mapping = this.xmlParserHelper.getJaxbRoot(stream, EntityMappings.class, schema);
                if (mapping == null) continue;
                this.entityMappings.add(mapping);
            }
            catch (XmlParsingException e) {
                this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to parse " + mappingFile + ": " + e.getMessage());
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean mappingFilesUnchanged(Collection<String> mappingFileNames) {
        boolean mappingFilesUnchanged = false;
        FileTimeStampChecker fileStampCheck = new FileTimeStampChecker();
        for (String mappingFile : mappingFileNames) {
            try {
                URL url = this.getClass().getResource(mappingFile);
                if (url == null) continue;
                File file = new File(url.toURI());
                this.context.logMessage(Diagnostic.Kind.OTHER, "Check file  " + mappingFile);
                if (!file.exists()) continue;
                fileStampCheck.add(mappingFile, file.lastModified());
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        FileTimeStampChecker serializedTimeStampCheck = this.loadTimeStampCache();
        if (serializedTimeStampCheck.equals(fileStampCheck)) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "XML parsing will be skipped due to unchanged xml files");
            mappingFilesUnchanged = true;
        } else {
            this.saveTimeStampCache(fileStampCheck);
        }
        return mappingFilesUnchanged;
    }

    private void saveTimeStampCache(FileTimeStampChecker fileStampCheck) {
        File file = this.getSerializationTmpFile();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
            out.writeObject(fileStampCheck);
            this.context.logMessage(Diagnostic.Kind.OTHER, "Serialized " + fileStampCheck + " into " + file.getAbsolutePath());
        }
        catch (IOException e) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Error serializing  " + fileStampCheck);
        }
    }

    private File getSerializationTmpFile() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        return new File(tmpDir, SERIALIZATION_FILE_NAME);
    }

    /*
     * Loose catch block
     */
    private FileTimeStampChecker loadTimeStampCache() {
        File file;
        block31: {
            FileTimeStampChecker fileTimeStampChecker;
            Throwable throwable;
            ObjectInputStream in;
            Throwable throwable2;
            FileInputStream fileInputStream;
            block29: {
                block30: {
                    block27: {
                        block28: {
                            file = this.getSerializationTmpFile();
                            if (!file.exists()) break block31;
                            fileInputStream = new FileInputStream(file);
                            throwable2 = null;
                            in = new ObjectInputStream(fileInputStream);
                            throwable = null;
                            fileTimeStampChecker = (FileTimeStampChecker)in.readObject();
                            if (in == null) break block27;
                            if (throwable == null) break block28;
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block27;
                        }
                        in.close();
                    }
                    if (fileInputStream == null) break block29;
                    if (throwable2 == null) break block30;
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    break block29;
                }
                fileInputStream.close();
            }
            return fileTimeStampChecker;
            {
                catch (Throwable throwable5) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    if (in != null) {
                                        if (throwable != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            in.close();
                                        }
                                    }
                                    throw throwable6;
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable2 = throwable8;
                                throw throwable8;
                            }
                        }
                        catch (Throwable throwable9) {
                            if (fileInputStream != null) {
                                if (throwable2 != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable2.addSuppressed(throwable10);
                                    }
                                } else {
                                    fileInputStream.close();
                                }
                            }
                            throw throwable9;
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        this.context.logMessage(Diagnostic.Kind.OTHER, "Error de-serializing  " + file);
        return new FileTimeStampChecker();
    }

    private void parseEntities(Collection<Entity> entities, String defaultPackageName) {
        for (Entity entity : entities) {
            String fqcn = StringUtil.determineFullyQualifiedClassName(defaultPackageName, entity.getClazz());
            if (!this.xmlMappedTypeExists(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " is mapped in xml, but class does not exist. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(entity, defaultPackageName, this.getXmlMappedType(fqcn), this.context);
            if (this.context.containsMetaEntity(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " was already processed once. Skipping second occurrence.");
            }
            this.context.addMetaEntity(fqcn, metaEntity);
        }
    }

    private void parseEmbeddable(Collection<Embeddable> embeddables, String defaultPackageName) {
        for (Embeddable embeddable : embeddables) {
            String fqcn = StringUtil.determineFullyQualifiedClassName(defaultPackageName, embeddable.getClazz());
            String pkg = StringUtil.packageNameFromFqcn(fqcn);
            if (!this.xmlMappedTypeExists(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " is mapped in xml, but class does not exist. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(embeddable, pkg, this.getXmlMappedType(fqcn), this.context);
            if (this.context.containsMetaEmbeddable(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " was already processed once. Skipping second occurrence.");
            }
            this.context.addMetaEmbeddable(fqcn, metaEntity);
        }
    }

    private void parseMappedSuperClass(Collection<MappedSuperclass> mappedSuperClasses, String defaultPackageName) {
        for (MappedSuperclass mappedSuperClass : mappedSuperClasses) {
            String fqcn = StringUtil.determineFullyQualifiedClassName(defaultPackageName, mappedSuperClass.getClazz());
            String pkg = StringUtil.packageNameFromFqcn(fqcn);
            if (!this.xmlMappedTypeExists(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " is mapped in xml, but class does not exist. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(mappedSuperClass, pkg, this.getXmlMappedType(fqcn), this.context);
            if (this.context.containsMetaEntity(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " was already processed once. Skipping second occurrence.");
            }
            this.context.addMetaEntity(fqcn, metaEntity);
        }
    }

    private boolean xmlMappedTypeExists(String fullyQualifiedClassName) {
        Elements utils = this.context.getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName) != null;
    }

    private TypeElement getXmlMappedType(String fullyQualifiedClassName) {
        Elements utils = this.context.getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName);
    }

    private org.hibernate.jpamodelgen.util.AccessType determineEntityAccessType(EntityMappings mappings) {
        org.hibernate.jpamodelgen.util.AccessType accessType = this.context.getPersistenceUnitDefaultAccessType();
        if (mappings.getAccess() != null) {
            accessType = this.mapXmlAccessTypeToJpaAccessType(mappings.getAccess());
        }
        return accessType;
    }

    private void determineXmlAccessTypes() {
        for (EntityMappings mappings : this.entityMappings) {
            AccessTypeInformation accessInfo;
            AccessType type;
            org.hibernate.jpamodelgen.util.AccessType explicitAccessType;
            String fqcn;
            String name;
            String packageName = mappings.getPackage();
            org.hibernate.jpamodelgen.util.AccessType defaultAccessType = this.determineEntityAccessType(mappings);
            for (Entity entity : mappings.getEntity()) {
                name = entity.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                explicitAccessType = null;
                type = entity.getAccess();
                if (type != null) {
                    explicitAccessType = this.mapXmlAccessTypeToJpaAccessType(type);
                }
                accessInfo = new AccessTypeInformation(fqcn, explicitAccessType, defaultAccessType);
                this.context.addAccessTypeInformation(fqcn, accessInfo);
            }
            for (MappedSuperclass mappedSuperClass : mappings.getMappedSuperclass()) {
                name = mappedSuperClass.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                explicitAccessType = null;
                type = mappedSuperClass.getAccess();
                if (type != null) {
                    explicitAccessType = this.mapXmlAccessTypeToJpaAccessType(type);
                }
                accessInfo = new AccessTypeInformation(fqcn, explicitAccessType, defaultAccessType);
                this.context.addAccessTypeInformation(fqcn, accessInfo);
            }
            for (Embeddable embeddable : mappings.getEmbeddable()) {
                name = embeddable.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                explicitAccessType = null;
                type = embeddable.getAccess();
                if (type != null) {
                    explicitAccessType = this.mapXmlAccessTypeToJpaAccessType(type);
                }
                accessInfo = new AccessTypeInformation(fqcn, explicitAccessType, defaultAccessType);
                this.context.addAccessTypeInformation(fqcn, accessInfo);
            }
        }
    }

    private void determineAnnotationAccessTypes() {
        for (EntityMappings mappings : this.entityMappings) {
            TypeElement element;
            String fqcn;
            String name;
            String packageName = mappings.getPackage();
            for (Entity entity : mappings.getEntity()) {
                name = entity.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                element = this.context.getTypeElementForFullyQualifiedName(fqcn);
                if (element == null) continue;
                TypeUtils.determineAccessTypeForHierarchy(element, this.context);
            }
            for (MappedSuperclass mappedSuperClass : mappings.getMappedSuperclass()) {
                name = mappedSuperClass.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                element = this.context.getTypeElementForFullyQualifiedName(fqcn);
                if (element == null) continue;
                TypeUtils.determineAccessTypeForHierarchy(element, this.context);
            }
        }
    }

    private void determineDefaultAccessTypeAndMetaCompleteness() {
        for (EntityMappings mappings : this.entityMappings) {
            PersistenceUnitMetadata meta = mappings.getPersistenceUnitMetadata();
            if (meta != null) {
                AccessType xmlAccessType;
                PersistenceUnitDefaults persistenceUnitDefaults;
                if (meta.getXmlMappingMetadataComplete() != null) {
                    this.context.mappingDocumentFullyXmlConfigured(true);
                } else {
                    this.context.mappingDocumentFullyXmlConfigured(false);
                }
                if ((persistenceUnitDefaults = meta.getPersistenceUnitDefaults()) == null || (xmlAccessType = persistenceUnitDefaults.getAccess()) == null) continue;
                this.context.setPersistenceUnitDefaultAccessType(this.mapXmlAccessTypeToJpaAccessType(xmlAccessType));
                continue;
            }
            this.context.mappingDocumentFullyXmlConfigured(false);
        }
    }

    private org.hibernate.jpamodelgen.util.AccessType mapXmlAccessTypeToJpaAccessType(AccessType xmlAccessType) {
        switch (xmlAccessType) {
            case FIELD: {
                return org.hibernate.jpamodelgen.util.AccessType.FIELD;
            }
            case PROPERTY: {
                return org.hibernate.jpamodelgen.util.AccessType.PROPERTY;
            }
        }
        return null;
    }
}

