/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.maven;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.hibernate.bytecode.buildtime.CGLIBInstrumenter;
import org.hibernate.bytecode.buildtime.Instrumenter;
import org.hibernate.bytecode.buildtime.JavassistInstrumenter;
import org.hibernate.bytecode.buildtime.Logger;

public class InstrumentationMojo
extends AbstractMojo
implements Instrumenter.Options {
    private MavenProject project;
    private File instrumentationDirectory;
    private boolean extended;
    private String provider;

    public boolean performExtendedInstrumentation() {
        return this.extended;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.provider == null) {
            this.provider = this.determineProvider();
            if (this.provider == null) {
                throw new MojoExecutionException("Unable to determine provider to use");
            }
        }
        Instrumenter instrumenter = this.resolveInstrumenter(this.provider, new LoggingBridge());
        try {
            instrumenter.execute(this.collectFilesToProcess());
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Error executing instrumentation", t);
        }
    }

    private Set collectFilesToProcess() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.instrumentationDirectory);
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.addDefaultExcludes();
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        HashSet<String> fileSet = new HashSet<String>(includedFiles.length + (int)(0.75 * (double)includedFiles.length) + 1);
        fileSet.addAll(Arrays.asList(includedFiles));
        return fileSet;
    }

    private Instrumenter resolveInstrumenter(String provider, Logger logger) throws MojoExecutionException {
        if ("javassist".equals(provider)) {
            return new JavassistInstrumenter(logger, (Instrumenter.Options)this);
        }
        if ("cglib".equals(provider)) {
            return new CGLIBInstrumenter(logger, (Instrumenter.Options)this);
        }
        throw new MojoExecutionException("Unable to resolve provider [" + provider + "] to appropriate instrumenter");
    }

    private String determineProvider() {
        if (this.project.getCompileArtifacts() != null) {
            boolean foundCglib = false;
            Iterator itr = this.project.getCompileArtifacts().iterator();
            while (itr.hasNext()) {
                Artifact artifact = (Artifact)itr.next();
                if ("javassist".equals(artifact.getGroupId()) && "javassist".equals(artifact.getArtifactId())) {
                    return "javassist";
                }
                if (!"org.hibernate".equals(artifact.getGroupId()) || !"hibernate-cglib-repack".equals(artifact.getArtifactId())) continue;
                foundCglib = true;
            }
            if (foundCglib) {
                return "cglib";
            }
        }
        return null;
    }

    private class LoggingBridge
    implements Logger {
        private LoggingBridge() {
        }

        public void trace(String message) {
            InstrumentationMojo.this.getLog().debug((CharSequence)message);
        }

        public void debug(String message) {
            InstrumentationMojo.this.getLog().debug((CharSequence)message);
        }

        public void info(String message) {
            InstrumentationMojo.this.getLog().info((CharSequence)message);
        }

        public void warn(String message) {
            InstrumentationMojo.this.getLog().warn((CharSequence)message);
        }

        public void error(String message) {
            InstrumentationMojo.this.getLog().error((CharSequence)message);
        }
    }
}

