/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.HibernateException;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.engine.spi.CacheImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public class CacheImpl
implements CacheImplementor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(CacheImpl.class);
    private final SessionFactoryImplementor sessionFactory;
    private final SessionFactoryOptions settings;
    private final transient QueryCache queryCache;
    private final transient RegionFactory regionFactory;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient ConcurrentMap<String, QueryCache> queryCaches;
    private final transient ConcurrentMap<String, EntityRegion> entityRegionMap = new ConcurrentHashMap<String, EntityRegion>();
    private final transient ConcurrentMap<String, CollectionRegion> collectionRegionMap = new ConcurrentHashMap<String, CollectionRegion>();
    private final transient ConcurrentMap<String, NaturalIdRegion> naturalIdRegionMap = new ConcurrentHashMap<String, NaturalIdRegion>();
    private final transient ConcurrentMap<String, Region> otherRegionMap = new ConcurrentHashMap<String, Region>();

    public CacheImpl(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.settings = sessionFactory.getSessionFactoryOptions();
        this.regionFactory = this.settings.getServiceRegistry().getService(RegionFactory.class);
        this.regionFactory.start(this.settings, sessionFactory.getProperties());
        if (this.settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(this.settings, sessionFactory.getProperties(), sessionFactory);
            this.queryCache = this.settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, this.settings, sessionFactory.getProperties());
            this.queryCaches = new ConcurrentHashMap<String, QueryCache>();
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
    }

    @Override
    public boolean containsEntity(Class entityClass, Serializable identifier) {
        return this.containsEntity(entityClass.getName(), identifier);
    }

    @Override
    public boolean containsEntity(String entityName, Serializable identifier) {
        EntityPersister p = this.sessionFactory.getEntityPersister(entityName);
        if (p.hasCache()) {
            EntityRegionAccessStrategy cache = p.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(identifier, p, this.sessionFactory, null);
            return cache.getRegion().contains(key);
        }
        return false;
    }

    @Override
    public void evictEntity(Class entityClass, Serializable identifier) {
        this.evictEntity(entityClass.getName(), identifier);
    }

    @Override
    public void evictEntity(String entityName, Serializable identifier) {
        EntityPersister p = this.sessionFactory.getEntityPersister(entityName);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", MessageHelper.infoString(p, identifier, this.sessionFactory));
            }
            EntityRegionAccessStrategy cache = p.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(identifier, p, this.sessionFactory, null);
            cache.evict(key);
        }
    }

    @Override
    public void evictEntityRegion(Class entityClass) {
        this.evictEntityRegion(entityClass.getName());
    }

    @Override
    public void evictEntityRegion(String entityName) {
        EntityPersister p = this.sessionFactory.getEntityPersister(entityName);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", p.getEntityName());
            }
            p.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictEntityRegions() {
        for (String s : this.sessionFactory.getEntityPersisters().keySet()) {
            this.evictEntityRegion(s);
        }
    }

    @Override
    public void evictNaturalIdRegion(Class entityClass) {
        this.evictNaturalIdRegion(entityClass.getName());
    }

    @Override
    public void evictNaturalIdRegion(String entityName) {
        EntityPersister p = this.sessionFactory.getEntityPersister(entityName);
        if (p.hasNaturalIdCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting natural-id cache: %s", p.getEntityName());
            }
            p.getNaturalIdCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictNaturalIdRegions() {
        for (String s : this.sessionFactory.getEntityPersisters().keySet()) {
            this.evictNaturalIdRegion(s);
        }
    }

    @Override
    public boolean containsCollection(String role, Serializable ownerIdentifier) {
        CollectionPersister p = this.sessionFactory.getCollectionPersister(role);
        if (p.hasCache()) {
            CollectionRegionAccessStrategy cache = p.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(ownerIdentifier, p, this.sessionFactory, null);
            return cache.getRegion().contains(key);
        }
        return false;
    }

    @Override
    public void evictCollection(String role, Serializable ownerIdentifier) {
        CollectionPersister p = this.sessionFactory.getCollectionPersister(role);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", MessageHelper.collectionInfoString(p, ownerIdentifier, this.sessionFactory));
            }
            CollectionRegionAccessStrategy cache = p.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(ownerIdentifier, p, this.sessionFactory, null);
            cache.evict(key);
        }
    }

    @Override
    public void evictCollectionRegion(String role) {
        CollectionPersister p = this.sessionFactory.getCollectionPersister(role);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", p.getRole());
            }
            p.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictCollectionRegions() {
        for (String s : this.sessionFactory.getCollectionPersisters().keySet()) {
            this.evictCollectionRegion(s);
        }
    }

    @Override
    public boolean containsQuery(String regionName) {
        if (this.sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled()) {
            return this.queryCaches.containsKey(regionName);
        }
        return false;
    }

    @Override
    public void evictDefaultQueryRegion() {
        if (this.sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evicting default query region cache.");
            }
            this.sessionFactory.getQueryCache().clear();
        }
    }

    @Override
    public void evictQueryRegion(String regionName) {
        QueryCache namedQueryCache;
        if (regionName == null) {
            throw new NullPointerException("Region-name cannot be null (use Cache#evictDefaultQueryRegion to evict the default query cache)");
        }
        if (this.sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled() && (namedQueryCache = (QueryCache)this.queryCaches.get(regionName)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting query cache, region: %s", regionName);
            }
            namedQueryCache.clear();
        }
    }

    @Override
    public void evictQueryRegions() {
        this.evictDefaultQueryRegion();
        if (CollectionHelper.isEmpty(this.queryCaches)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evicting cache of all query regions.");
        }
        for (QueryCache queryCache : this.queryCaches.values()) {
            queryCache.clear();
        }
    }

    @Override
    public void close() {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            for (QueryCache cache : this.queryCaches.values()) {
                cache.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.regionFactory.stop();
    }

    @Override
    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCache getQueryCache(String regionName) throws HibernateException {
        if (regionName == null) {
            return this.getQueryCache();
        }
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        QueryCache currentQueryCache = (QueryCache)this.queryCaches.get(regionName);
        if (currentQueryCache == null) {
            ConcurrentMap<String, QueryCache> concurrentMap = this.queryCaches;
            synchronized (concurrentMap) {
                currentQueryCache = (QueryCache)this.queryCaches.get(regionName);
                if (currentQueryCache != null) {
                    return currentQueryCache;
                }
                currentQueryCache = this.settings.getQueryCacheFactory().getQueryCache(regionName, this.updateTimestampsCache, this.settings, this.sessionFactory.getProperties());
                this.queryCaches.put(regionName, currentQueryCache);
            }
        }
        return currentQueryCache;
    }

    @Override
    public void addCacheRegion(String name, Region region) {
        boolean isOtherRegion = true;
        if (EntityRegion.class.isInstance(region)) {
            this.entityRegionMap.put(name, (EntityRegion)region);
            isOtherRegion = false;
        }
        if (CollectionRegion.class.isInstance(region)) {
            this.collectionRegionMap.put(name, (CollectionRegion)region);
            isOtherRegion = false;
        }
        if (NaturalIdRegion.class.isInstance(region)) {
            this.naturalIdRegionMap.put(name, (NaturalIdRegion)region);
            isOtherRegion = false;
        }
        if (isOtherRegion) {
            this.otherRegionMap.put(name, region);
        }
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    @Override
    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.clear();
        }
    }

    @Override
    public Region getSecondLevelCacheRegion(String regionName) {
        Region region = (Region)this.entityRegionMap.get(regionName);
        if (region != null) {
            return region;
        }
        region = (Region)this.collectionRegionMap.get(regionName);
        if (region != null) {
            return region;
        }
        region = (Region)this.naturalIdRegionMap.get(regionName);
        if (region != null) {
            return region;
        }
        region = (Region)this.otherRegionMap.get(regionName);
        if (region != null) {
            return region;
        }
        for (QueryCache queryCacheValue : this.queryCaches.values()) {
            if (!queryCacheValue.getRegion().getName().equals(regionName)) continue;
            return queryCacheValue.getRegion();
        }
        if (this.queryCache.getRegion().getName().equals(regionName)) {
            return this.queryCache.getRegion();
        }
        if (this.updateTimestampsCache.getRegion().getName().equals(regionName)) {
            return this.updateTimestampsCache.getRegion();
        }
        return null;
    }

    @Override
    public Region getNaturalIdCacheRegion(String regionName) {
        return (Region)this.naturalIdRegionMap.get(regionName);
    }

    @Override
    public Map<String, Region> getAllSecondLevelCacheRegions() {
        HashMap<String, Region> allCacheRegions = new HashMap<String, Region>();
        if (this.settings.isQueryCacheEnabled()) {
            allCacheRegions.put(this.updateTimestampsCache.getRegion().getName(), this.updateTimestampsCache.getRegion());
            allCacheRegions.put(this.queryCache.getRegion().getName(), this.queryCache.getRegion());
            for (QueryCache queryCacheValue : this.queryCaches.values()) {
                allCacheRegions.put(queryCacheValue.getRegion().getName(), queryCacheValue.getRegion());
            }
        }
        allCacheRegions.putAll(this.otherRegionMap);
        allCacheRegions.putAll(this.naturalIdRegionMap);
        allCacheRegions.putAll(this.collectionRegionMap);
        allCacheRegions.putAll(this.entityRegionMap);
        return allCacheRegions;
    }

    @Override
    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    @Override
    public void evictAllRegions() {
        this.evictCollectionRegions();
        this.evictDefaultQueryRegion();
        this.evictEntityRegions();
        this.evictQueryRegions();
        this.evictNaturalIdRegions();
    }
}

