/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.ForeignKeyInformation;
import org.hibernate.tool.schema.extract.spi.IndexInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.internal.DefaultSchemaFilter;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.internal.exec.JdbcConnectionContextSharedImpl;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaMigrator;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public class SchemaMigratorImpl
implements SchemaMigrator {
    private static final Logger log = Logger.getLogger(SchemaMigratorImpl.class);
    private final HibernateSchemaManagementTool tool;
    private final SchemaFilter schemaFilter;
    private UniqueConstraintSchemaUpdateStrategy uniqueConstraintStrategy;

    public SchemaMigratorImpl(HibernateSchemaManagementTool tool) {
        this(tool, DefaultSchemaFilter.INSTANCE);
    }

    public SchemaMigratorImpl(HibernateSchemaManagementTool tool, SchemaFilter schemaFilter) {
        this.tool = tool;
        this.schemaFilter = schemaFilter;
    }

    public void setUniqueConstraintStrategy(UniqueConstraintSchemaUpdateStrategy uniqueConstraintStrategy) {
        this.uniqueConstraintStrategy = uniqueConstraintStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doMigration(Metadata metadata, ExecutionOptions options, TargetDescriptor targetDescriptor) {
        if (targetDescriptor.getTargetTypes().isEmpty()) {
            return;
        }
        JdbcContext jdbcContext = this.tool.resolveJdbcContext(options.getConfigurationValues());
        JdbcConnectionContextSharedImpl connectionContext = new JdbcConnectionContextSharedImpl(jdbcContext.getJdbcConnectionAccess(), jdbcContext.getSqlStatementLogger(), targetDescriptor.getTargetTypes().contains((Object)TargetType.DATABASE));
        try {
            DatabaseInformation databaseInformation = Helper.buildDatabaseInformation(this.tool.getServiceRegistry(), connectionContext, metadata.getDatabase().getDefaultNamespace().getName());
            GenerationTarget[] targets = this.tool.buildGenerationTargets(targetDescriptor, connectionContext, options.getConfigurationValues());
            try {
                this.doMigration(metadata, databaseInformation, options, jdbcContext.getDialect(), targets);
            }
            finally {
                try {
                    databaseInformation.cleanup();
                }
                catch (Exception e) {
                    log.debug((Object)("Problem releasing DatabaseInformation : " + e.getMessage()));
                }
            }
        }
        finally {
            connectionContext.reallyRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMigration(Metadata metadata, DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, GenerationTarget ... targets) {
        for (GenerationTarget target : targets) {
            target.prepare();
        }
        try {
            this.performMigration(metadata, existingDatabase, options, dialect, targets);
        }
        finally {
            for (GenerationTarget target : targets) {
                try {
                    target.release();
                }
                catch (Exception e) {
                    log.debugf("Problem releasing GenerationTarget [%s] : %s", (Object)target, (Object)e.getMessage());
                }
            }
        }
    }

    private void performMigration(Metadata metadata, DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, GenerationTarget ... targets) {
        TableInformation tableInformation;
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        HashSet<String> exportIdentifiers = new HashSet<String>(50);
        Database database = metadata.getDatabase();
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaMigratorImpl.applySqlStrings(true, dialect.getAuxiliaryDatabaseObjectExporter().getSqlDropStrings(auxiliaryDatabaseObject, metadata), formatter, options, targets);
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaMigratorImpl.applySqlStrings(true, auxiliaryDatabaseObject.sqlCreateStrings(dialect), formatter, options, targets);
        }
        boolean tryToCreateCatalogs = false;
        boolean tryToCreateSchemas = false;
        if (options.shouldManageNamespaces()) {
            if (dialect.canCreateSchema()) {
                tryToCreateSchemas = true;
            }
            if (dialect.canCreateCatalog()) {
                tryToCreateCatalogs = true;
            }
        }
        HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
        for (Namespace namespace : database.getNamespaces()) {
            if (!this.schemaFilter.includeNamespace(namespace)) continue;
            if (tryToCreateCatalogs || tryToCreateSchemas) {
                if (tryToCreateCatalogs) {
                    Identifier catalogLogicalName = namespace.getName().getCatalog();
                    Identifier catalogPhysicalName = namespace.getPhysicalName().getCatalog();
                    if (catalogPhysicalName != null && !exportedCatalogs.contains(catalogLogicalName) && !existingDatabase.catalogExists(catalogLogicalName)) {
                        SchemaMigratorImpl.applySqlStrings(false, dialect.getCreateCatalogCommand(catalogPhysicalName.render(dialect)), formatter, options, targets);
                        exportedCatalogs.add(catalogLogicalName);
                    }
                }
                if (tryToCreateSchemas && namespace.getPhysicalName().getSchema() != null && !existingDatabase.schemaExists(namespace.getName())) {
                    SchemaMigratorImpl.applySqlStrings(false, dialect.getCreateSchemaCommand(namespace.getPhysicalName().getSchema().render(dialect)), formatter, options, targets);
                }
            }
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable() || !this.schemaFilter.includeTable(table)) continue;
                this.checkExportIdentifier(table, exportIdentifiers);
                tableInformation = existingDatabase.getTableInformation(table.getQualifiedTableName());
                if (tableInformation != null && !tableInformation.isPhysicalTable()) continue;
                if (tableInformation == null) {
                    this.createTable(table, dialect, metadata, formatter, options, targets);
                    continue;
                }
                this.migrateTable(table, tableInformation, dialect, metadata, formatter, options, targets);
            }
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable() || !this.schemaFilter.includeTable(table) || (tableInformation = existingDatabase.getTableInformation(table.getQualifiedTableName())) != null && !tableInformation.isPhysicalTable()) continue;
                this.applyIndexes(table, tableInformation, dialect, metadata, formatter, options, targets);
                this.applyUniqueKeys(table, tableInformation, dialect, metadata, formatter, options, targets);
            }
            for (Sequence sequence : namespace.getSequences()) {
                this.checkExportIdentifier(sequence, exportIdentifiers);
                SequenceInformation sequenceInformation = existingDatabase.getSequenceInformation(sequence.getName());
                if (sequenceInformation != null) continue;
                SchemaMigratorImpl.applySqlStrings(false, dialect.getSequenceExporter().getSqlCreateStrings(sequence, metadata), formatter, options, targets);
            }
        }
        for (Namespace namespace : database.getNamespaces()) {
            if (!this.schemaFilter.includeNamespace(namespace)) continue;
            for (Table table : namespace.getTables()) {
                if (!this.schemaFilter.includeTable(table) || (tableInformation = existingDatabase.getTableInformation(table.getQualifiedTableName())) != null && !tableInformation.isPhysicalTable()) continue;
                this.applyForeignKeys(table, tableInformation, dialect, metadata, formatter, options, targets);
            }
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaMigratorImpl.applySqlStrings(true, auxiliaryDatabaseObject.sqlCreateStrings(dialect), formatter, options, targets);
        }
    }

    private void createTable(Table table, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        SchemaMigratorImpl.applySqlStrings(false, dialect.getTableExporter().getSqlCreateStrings(table, metadata), formatter, options, targets);
    }

    private void migrateTable(Table table, TableInformation tableInformation, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        Database database = metadata.getDatabase();
        SchemaMigratorImpl.applySqlStrings(false, table.sqlAlterStrings(dialect, metadata, tableInformation, this.getDefaultCatalogName(database, dialect), this.getDefaultSchemaName(database, dialect)), formatter, options, targets);
    }

    private void applyIndexes(Table table, TableInformation tableInformation, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        Exporter<Index> exporter = dialect.getIndexExporter();
        Iterator<Index> indexItr = table.getIndexIterator();
        while (indexItr.hasNext()) {
            IndexInformation existingIndex;
            Index index = indexItr.next();
            if (StringHelper.isEmpty(index.getName()) || tableInformation != null && (existingIndex = this.findMatchingIndex(index, tableInformation)) != null) continue;
            SchemaMigratorImpl.applySqlStrings(false, exporter.getSqlCreateStrings(index, metadata), formatter, options, targets);
        }
    }

    private IndexInformation findMatchingIndex(Index index, TableInformation tableInformation) {
        return tableInformation.getIndex(Identifier.toIdentifier(index.getName()));
    }

    private void applyUniqueKeys(Table table, TableInformation tableInfo, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (this.uniqueConstraintStrategy == null) {
            this.uniqueConstraintStrategy = this.determineUniqueConstraintSchemaUpdateStrategy(metadata);
        }
        if (this.uniqueConstraintStrategy == UniqueConstraintSchemaUpdateStrategy.SKIP) {
            return;
        }
        Exporter<Constraint> exporter = dialect.getUniqueKeyExporter();
        Iterator<UniqueKey> ukItr = table.getUniqueKeyIterator();
        while (ukItr.hasNext()) {
            IndexInformation indexInfo;
            UniqueKey uniqueKey = ukItr.next();
            if (tableInfo != null && StringHelper.isNotEmpty(uniqueKey.getName()) && (indexInfo = tableInfo.getIndex(Identifier.toIdentifier(uniqueKey.getName()))) != null) continue;
            if (this.uniqueConstraintStrategy == UniqueConstraintSchemaUpdateStrategy.DROP_RECREATE_QUIETLY) {
                SchemaMigratorImpl.applySqlStrings(true, exporter.getSqlDropStrings(uniqueKey, metadata), formatter, options, targets);
            }
            SchemaMigratorImpl.applySqlStrings(true, exporter.getSqlCreateStrings(uniqueKey, metadata), formatter, options, targets);
        }
    }

    private UniqueConstraintSchemaUpdateStrategy determineUniqueConstraintSchemaUpdateStrategy(Metadata metadata) {
        ConfigurationService cfgService = ((MetadataImplementor)metadata).getMetadataBuildingOptions().getServiceRegistry().getService(ConfigurationService.class);
        return UniqueConstraintSchemaUpdateStrategy.interpret(cfgService.getSetting("hibernate.schema_update.unique_constraint_strategy", StandardConverters.STRING));
    }

    private void applyForeignKeys(Table table, TableInformation tableInformation, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (!dialect.hasAlterTable()) {
            return;
        }
        Exporter<ForeignKey> exporter = dialect.getForeignKeyExporter();
        Iterator fkItr = table.getForeignKeyIterator();
        while (fkItr.hasNext()) {
            ForeignKeyInformation existingForeignKey;
            ForeignKey foreignKey = (ForeignKey)fkItr.next();
            if (!foreignKey.isPhysicalConstraint() || !foreignKey.isCreationEnabled() || tableInformation != null && (existingForeignKey = this.findMatchingForeignKey(foreignKey, tableInformation)) != null) continue;
            SchemaMigratorImpl.applySqlStrings(false, exporter.getSqlCreateStrings(foreignKey, metadata), formatter, options, targets);
        }
    }

    private ForeignKeyInformation findMatchingForeignKey(ForeignKey foreignKey, TableInformation tableInformation) {
        if (foreignKey.getName() == null) {
            return null;
        }
        return tableInformation.getForeignKey(Identifier.toIdentifier(foreignKey.getName()));
    }

    private void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException(String.format("Export identifier [%s] encountered more than once", exportIdentifier));
        }
        exportIdentifiers.add(exportIdentifier);
    }

    private static void applySqlStrings(boolean quiet, String[] sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings == null) {
            return;
        }
        for (String sqlString : sqlStrings) {
            SchemaMigratorImpl.applySqlString(quiet, sqlString, formatter, options, targets);
        }
    }

    private static void applySqlString(boolean quiet, String sqlString, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (StringHelper.isEmpty(sqlString)) {
            return;
        }
        for (GenerationTarget target : targets) {
            try {
                target.accept(formatter.format(sqlString));
            }
            catch (CommandAcceptanceException e) {
                if (quiet) continue;
                options.getExceptionHandler().handleException(e);
            }
        }
    }

    private static void applySqlStrings(boolean quiet, Iterator<String> sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings == null) {
            return;
        }
        while (sqlStrings.hasNext()) {
            String sqlString = sqlStrings.next();
            SchemaMigratorImpl.applySqlString(quiet, sqlString, formatter, options, targets);
        }
    }

    private String getDefaultCatalogName(Database database, Dialect dialect) {
        Identifier identifier = database.getDefaultNamespace().getPhysicalName().getCatalog();
        return identifier == null ? null : identifier.render(dialect);
    }

    private String getDefaultSchemaName(Database database, Dialect dialect) {
        Identifier identifier = database.getDefaultNamespace().getPhysicalName().getSchema();
        return identifier == null ? null : identifier.render(dialect);
    }
}

