/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.osgi.CachedBundle;
import org.osgi.framework.Bundle;

public class OsgiClassLoader
extends ClassLoader {
    private Map<String, CachedBundle> bundles = new HashMap<String, CachedBundle>();
    private Map<String, Class<?>> classCache = new HashMap();
    private Map<String, URL> resourceCache = new HashMap<String, URL>();
    private Map<String, Enumeration<URL>> resourceListCache = new HashMap<String, Enumeration<URL>>();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classCache.containsKey(name)) {
            return this.classCache.get(name);
        }
        for (CachedBundle bundle : this.bundles.values()) {
            try {
                Class clazz = bundle.loadClass(name);
                if (clazz == null) continue;
                this.classCache.put(name, clazz);
                return clazz;
            }
            catch (Exception ignore) {
            }
        }
        throw new ClassNotFoundException("Could not load requested class : " + name);
    }

    @Override
    protected URL findResource(String name) {
        if (this.resourceCache.containsKey(name)) {
            return this.resourceCache.get(name);
        }
        for (CachedBundle bundle : this.bundles.values()) {
            try {
                URL resource = bundle.getResource(name);
                if (resource == null) continue;
                this.resourceCache.put(name, resource);
                return resource;
            }
            catch (Exception ignore) {
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        if (this.resourceListCache.containsKey(name)) {
            return this.resourceListCache.get(name);
        }
        for (CachedBundle bundle : this.bundles.values()) {
            try {
                Enumeration resources = bundle.getResources(name);
                if (resources == null) continue;
                this.resourceListCache.put(name, resources);
                return resources;
            }
            catch (Exception ignore) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBundle(Bundle bundle) {
        if (bundle != null) {
            Map<String, CachedBundle> map = this.bundles;
            synchronized (map) {
                String key = OsgiClassLoader.getBundleKey(bundle);
                if (!this.bundles.containsKey(key)) {
                    this.bundles.put(key, new CachedBundle(bundle, key));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBundle(Bundle bundle) {
        if (bundle != null) {
            Map<String, CachedBundle> map = this.bundles;
            synchronized (map) {
                String key = OsgiClassLoader.getBundleKey(bundle);
                if (this.bundles.containsKey(key)) {
                    CachedBundle cachedBundle = this.bundles.remove(key);
                    this.clearCache(this.classCache, cachedBundle.getClassNames());
                    this.clearCache(this.resourceCache, cachedBundle.getResourceNames());
                    this.clearCache(this.resourceListCache, cachedBundle.getResourceListNames());
                }
            }
        }
    }

    private void clearCache(Map cache, List<String> names) {
        for (String name : names) {
            cache.remove(name);
        }
    }

    public void clear() {
        this.bundles.clear();
        this.classCache.clear();
        this.resourceCache.clear();
        this.resourceListCache.clear();
    }

    protected static String getBundleKey(Bundle bundle) {
        return bundle.getSymbolicName() + " " + bundle.getVersion().toString();
    }
}

