/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.persistence.spi.PersistenceProvider;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.osgi.OsgiPersistenceProviderService;
import org.hibernate.osgi.OsgiSessionFactoryService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class HibernateBundleActivator
implements BundleActivator {
    private ServiceRegistration<?> persistenceProviderService;
    private ServiceRegistration<?> sessionFactoryService;

    public void start(BundleContext context) throws Exception {
        OsgiClassLoader osgiClassLoader = new OsgiClassLoader();
        osgiClassLoader.addBundle(FrameworkUtil.getBundle(Session.class));
        osgiClassLoader.addBundle(FrameworkUtil.getBundle(HibernatePersistence.class));
        ClassLoaderHelper.overridenClassLoader = osgiClassLoader;
        OsgiJtaPlatform osgiJtaPlatform = new OsgiJtaPlatform(context);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("javax.persistence.provider", HibernatePersistence.class.getName());
        this.persistenceProviderService = context.registerService(PersistenceProvider.class.getName(), (Object)new OsgiPersistenceProviderService(osgiClassLoader, osgiJtaPlatform, context), properties);
        this.sessionFactoryService = context.registerService(SessionFactory.class.getName(), (Object)new OsgiSessionFactoryService(osgiClassLoader, osgiJtaPlatform, context), new Hashtable());
    }

    public void stop(BundleContext context) throws Exception {
        this.persistenceProviderService.unregister();
        this.persistenceProviderService = null;
        this.sessionFactoryService.unregister();
        this.sessionFactoryService = null;
        ClassLoaderHelper.overridenClassLoader = null;
    }
}

