/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiClassLoader
extends ClassLoader {
    private Set<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
    private Map<String, Class<?>> classCache = new HashMap();
    private Map<String, URL> resourceCache = new HashMap<String, URL>();

    public OsgiClassLoader() {
        super(null);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classCache.containsKey(name)) {
            return this.classCache.get(name);
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                Class<?> clazz = classLoader.loadClass(name);
                if (clazz == null) continue;
                this.classCache.put(name, clazz);
                return clazz;
            }
            catch (Exception exception) {
            }
        }
        throw new ClassNotFoundException("Could not load requested class : " + name);
    }

    @Override
    protected URL findResource(String name) {
        if (this.resourceCache.containsKey(name)) {
            return this.resourceCache.get(name);
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                URL resource = classLoader.getResource(name);
                if (resource == null) continue;
                this.resourceCache.put(name, resource);
                return resource;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        final ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>();
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                Enumeration<URL> resources = classLoader.getResources(name);
                if (resources == null) continue;
                enumerations.add(resources);
            }
            catch (Exception exception) {}
        }
        Enumeration<URL> aggEnumeration = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                for (Enumeration enumeration : enumerations) {
                    if (enumeration == null || !enumeration.hasMoreElements()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                for (Enumeration enumeration : enumerations) {
                    if (enumeration == null || !enumeration.hasMoreElements()) continue;
                    return (URL)enumeration.nextElement();
                }
                throw new NoSuchElementException();
            }
        };
        return aggEnumeration;
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void addBundle(Bundle bundle) {
        this.addClassLoader(((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader());
    }

    public void clear() {
        this.classCache.clear();
        this.resourceCache.clear();
    }

    public void removeBundle(Bundle bundle) {
        ArrayList<ClassLoader> toRemove = new ArrayList<ClassLoader>();
        for (ClassLoader cl : this.classLoaders) {
            Bundle b;
            if (!(cl instanceof BundleReference) || (b = ((BundleReference)cl).getBundle()) != bundle) continue;
            toRemove.add(cl);
        }
        if (this.classLoaders.removeAll(toRemove)) {
            this.clear();
        }
    }
}

