/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.spi.TypeContributor;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.osgi.util.OsgiServiceUtil;
import org.hibernate.service.BootstrapServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class OsgiSessionFactoryService
implements ServiceFactory {
    private OsgiClassLoader osgiClassLoader;
    private OsgiJtaPlatform osgiJtaPlatform;
    private BundleContext context;

    public OsgiSessionFactoryService(OsgiClassLoader osgiClassLoader, OsgiJtaPlatform osgiJtaPlatform, BundleContext context) {
        this.osgiClassLoader = osgiClassLoader;
        this.osgiJtaPlatform = osgiJtaPlatform;
        this.context = context;
    }

    public Object getService(Bundle requestingBundle, ServiceRegistration registration) {
        this.osgiClassLoader.addBundle(requestingBundle);
        Configuration configuration = new Configuration();
        configuration.getProperties().put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        configuration.configure();
        BootstrapServiceRegistryBuilder builder = new BootstrapServiceRegistryBuilder();
        builder.with((ClassLoader)this.osgiClassLoader);
        List<Integrator> integrators = OsgiServiceUtil.getServiceImpls(Integrator.class, this.context);
        for (Integrator integrator : integrators) {
            builder.with(integrator);
        }
        List<TypeContributor> typeContributors = OsgiServiceUtil.getServiceImpls(TypeContributor.class, this.context);
        for (TypeContributor typeContributor : typeContributors) {
            configuration.registerTypeContributor(typeContributor);
        }
        ServiceRegistry serviceRegistry = new ServiceRegistryBuilder(builder.build()).applySettings((Map)configuration.getProperties()).buildServiceRegistry();
        return configuration.buildSessionFactory(serviceRegistry);
    }

    public void ungetService(Bundle requestingBundle, ServiceRegistration registration, Object service) {
        ((SessionFactory)service).close();
    }
}

