/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.osgi.framework.Bundle;

public class OsgiPersistenceProvider
extends HibernatePersistenceProvider {
    private OsgiClassLoader osgiClassLoader;
    private OsgiJtaPlatform osgiJtaPlatform;
    private Bundle requestingBundle;

    public OsgiPersistenceProvider(OsgiClassLoader osgiClassLoader, OsgiJtaPlatform osgiJtaPlatform, Bundle requestingBundle) {
        this.osgiClassLoader = osgiClassLoader;
        this.osgiJtaPlatform = osgiJtaPlatform;
        this.requestingBundle = requestingBundle;
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        if (properties == null) {
            properties = new HashMap<String, OsgiJtaPlatform>();
        }
        properties.put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        this.osgiClassLoader.addBundle(this.requestingBundle);
        return super.createEntityManagerFactory(persistenceUnitName, properties);
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        if (properties == null) {
            properties = new HashMap<String, OsgiJtaPlatform>();
        }
        properties.put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        this.osgiClassLoader.addClassLoader(info.getClassLoader());
        return super.createContainerEntityManagerFactory(info, properties);
    }
}

