/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.lang.reflect.Array;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiServiceUtil {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(OsgiServiceUtil.class);

    public static <T> T[] getServiceImpls(Class<T> contract, BundleContext bundleContext) {
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, contract, null);
        try {
            Object[] services = serviceTracker.getServices();
            if (services != null) {
                return services;
            }
        }
        catch (Exception e) {
            LOG.unableToDiscoverOsgiService(contract.getName(), e);
        }
        return (Object[])Array.newInstance(contract, 0);
    }

    public static <T> T getServiceImpl(Class<T> contract, BundleContext bundleContext) {
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, contract, null);
        try {
            return (T)serviceTracker.waitForService(1000L);
        }
        catch (Exception e) {
            LOG.unableToDiscoverOsgiService(contract.getName(), e);
            return null;
        }
    }
}

