/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jgroups.impl.JGroupsBackendQueueProcessor;
import org.hibernate.search.backend.jgroups.impl.MasterNodeSelector;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy;
import org.hibernate.search.backend.spi.BackendQueueProcessor;

public class JGroupsReceivingMockBackend
extends JGroupsBackendQueueProcessor
implements BackendQueueProcessor {
    private volatile CountDownLatch threadTrap;
    private volatile boolean failOnMessage = false;

    public JGroupsReceivingMockBackend() {
        super((NodeSelectorStrategy)new MasterNodeSelector());
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        this.countDownAndJoin();
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        this.countDownAndJoin();
    }

    public void resetThreadTrap() {
        this.threadTrap = new CountDownLatch(2);
    }

    public void countDownAndJoin() {
        if (this.failOnMessage) {
            throw new NullPointerException("Simulated Failure");
        }
        System.out.println("[PREJOIN] Timestamp: " + System.nanoTime());
        try {
            this.threadTrap.countDown();
            this.threadTrap.await(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        System.out.println("[POSTJOIN] Timestamp: " + System.nanoTime());
    }

    public int releaseBlockedThreads() {
        int count = (int)this.threadTrap.getCount();
        for (int i = 0; i < count; ++i) {
            this.threadTrap.countDown();
        }
        return count;
    }

    public void induceFailure() {
        this.failOnMessage = true;
    }
}

