/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import org.hibernate.cfg.Configuration;
import org.hibernate.search.backend.jgroups.impl.MessageSenderService;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.test.jgroups.common.JGroupsCommonTest;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.jgroups.JChannel;
import org.junit.Assert;
import org.junit.Test;

public class InjectedChannelTest
extends JGroupsCommonTest {
    private JChannel masterChannel;
    private JChannel slaveChannel;

    @Test
    public void testInjectionHappened() throws Exception {
        MutableSearchFactory searchFactory = (MutableSearchFactory)this.getSearchFactory();
        MessageSenderService sender = (MessageSenderService)searchFactory.getServiceManager().requestService(MessageSenderService.class);
        Assert.assertTrue((boolean)this.masterChannel.getAddress().equals(sender.getAddress()));
    }

    @Override
    public void setUp() throws Exception {
        this.masterChannel = InjectedChannelTest.createChannel();
        this.slaveChannel = InjectedChannelTest.createChannel();
        this.forceConfigurationRebuild();
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            if (this.masterChannel != null) {
                this.masterChannel.close();
            }
            if (this.slaveChannel != null) {
                this.slaveChannel.close();
            }
        }
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", "jgroupsMaster");
        cfg.getProperties().put("hibernate.search.services.jgroups.providedChannel", this.masterChannel);
    }

    @Override
    protected void commonConfigure(Configuration cfg) {
        super.commonConfigure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", "jgroupsSlave");
        cfg.getProperties().put("hibernate.search.services.jgroups.providedChannel", this.slaveChannel);
    }

    private static JChannel createChannel() throws Exception {
        JChannel channel = new JChannel(ConfigurationParseHelper.locateConfig((String)"testing-flush-loopback.xml"));
        channel.connect("JGroupsCommonTest" + JGroupsCommonTest.CHANNEL_NAME);
        return channel;
    }
}

