/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.master;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jgroups.impl.MessageSerializationHelper;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.jgroups.master.TShirt;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JGroupsMasterTest
extends SearchTestBase {
    private final QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
    public static final String CHANNEL_NAME = UUID.randomUUID().toString();
    private JChannel channel;

    @Test
    public void testMessageSending() throws Exception {
        Assert.assertEquals((long)0L, (long)this.countByQuery("logo:jboss"));
        TShirt shirt = this.createObjectWithSQL();
        List<LuceneWork> queue = this.createDocumentAndWorkQueue(shirt);
        this.sendMessage(queue);
        boolean failed = true;
        for (int i = 0; i < 100; ++i) {
            Thread.sleep(100L);
            if (this.countByQuery("logo:jboss") != 1) continue;
            failed = false;
            break;
        }
        if (failed) {
            Assert.fail((String)"Message not received after waiting for long!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countByQuery(String luceneQueryString) throws ParseException {
        try (FullTextSession ftSess = Search.getFullTextSession((Session)this.openSession());){
            int n;
            ftSess.getTransaction().begin();
            try {
                Query luceneQuery = this.parser.parse(luceneQueryString);
                FullTextQuery query = ftSess.createFullTextQuery(luceneQuery, new Class[0]);
                List result = query.list();
                n = result.size();
            }
            catch (Throwable throwable) {
                ftSess.getTransaction().commit();
                throw throwable;
            }
            ftSess.getTransaction().commit();
            return n;
        }
    }

    private void prepareJGroupsChannel() throws Exception {
        this.channel = new JChannel(ConfigurationParseHelper.locateConfig((String)"testing-flush-loopback.xml"));
        this.channel.connect(CHANNEL_NAME);
    }

    private void sendMessage(List<LuceneWork> queue) throws Exception {
        String indexManagerName = "org.hibernate.search.test.jgroups.master.TShirt";
        IndexManager indexManager = this.getSearchFactoryImpl().getIndexManagerHolder().getIndexManager("org.hibernate.search.test.jgroups.master.TShirt");
        byte[] data = indexManager.getSerializer().toSerializedModel(queue);
        data = MessageSerializationHelper.prependString((String)"org.hibernate.search.test.jgroups.master.TShirt", (byte[])data);
        Message message = new Message(null, null, data);
        this.channel.send(message);
    }

    private List<LuceneWork> createDocumentAndWorkQueue(TShirt shirt) {
        Document doc = new Document();
        Field field = new Field("_hibernate_class", shirt.getClass().getName(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((IndexableField)field);
        field = new Field("id", "1", Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((IndexableField)field);
        field = new Field("logo", shirt.getLogo(), Field.Store.NO, Field.Index.ANALYZED);
        doc.add((IndexableField)field);
        DoubleField numField = new DoubleField("length", shirt.getLength(), Field.Store.NO);
        doc.add((IndexableField)numField);
        AddLuceneWork luceneWork = new AddLuceneWork((Serializable)Integer.valueOf(shirt.getId()), String.valueOf(shirt.getId()), shirt.getClass(), doc);
        ArrayList<LuceneWork> queue = new ArrayList<LuceneWork>();
        queue.add((LuceneWork)luceneWork);
        return queue;
    }

    private TShirt createObjectWithSQL() {
        Session s = this.openSession();
        s.getTransaction().begin();
        TShirt ts = new TShirt();
        ts.setLogo("JBoss balls");
        ts.setSize("large");
        ts.setLength(23.2);
        s.persist((Object)ts);
        s.getTransaction().commit();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        fullTextSession.beginTransaction();
        fullTextSession.purge(TShirt.class, (Serializable)Integer.valueOf(1));
        fullTextSession.getTransaction().commit();
        s.close();
        return ts;
    }

    @Before
    public void setUp() throws Exception {
        this.prepareJGroupsChannel();
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.channel.close();
        super.tearDown();
    }

    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", "jgroupsMaster");
        cfg.setProperty("hibernate.search.services.jgroups.clusterName", CHANNEL_NAME);
        cfg.setProperty("hibernate.search.services.jgroups.configurationFile", "testing-flush-loopback.xml");
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }
}

