/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.slave;

import java.util.List;
import org.hibernate.search.backend.jgroups.impl.MessageSerializationHelper;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;

public class JGroupsReceiver
extends ReceiverAdapter {
    public static volatile int queues;
    public static volatile int works;
    private final SearchIntegrator integrator;

    public JGroupsReceiver(SearchIntegrator integrator) {
        this.integrator = integrator;
    }

    public static void reset() {
        queues = 0;
        works = 0;
    }

    public void receive(Message message) {
        try {
            byte[] rawBuffer = message.getRawBuffer();
            int messageOffset = message.getOffset();
            int bufferLength = message.getLength();
            String indexName = MessageSerializationHelper.extractIndexName((int)messageOffset, (byte[])rawBuffer);
            byte[] serializedQueue = MessageSerializationHelper.extractSerializedQueue((int)messageOffset, (int)bufferLength, (byte[])rawBuffer);
            IndexManager indexManager = this.integrator.getIndexManager(indexName);
            List queue = indexManager.getSerializer().toLuceneWorks(serializedQueue);
            ++queues;
            works += queue.size();
        }
        catch (ClassCastException e) {
            throw new SearchException((Throwable)e);
        }
    }
}

