/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import com.google.gson.GsonBuilder;
import java.util.Properties;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientFactory;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.elasticsearch.dialect.impl.ElasticsearchDialect;
import org.hibernate.search.elasticsearch.dialect.impl.ElasticsearchDialectFactory;
import org.hibernate.search.elasticsearch.impl.DefaultElasticsearchService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.spi.BuildContext;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class DefaultElasticsearchServiceTest {
    @Mock(type=MockType.NICE)
    private BuildContext contextMock;
    @Mock(type=MockType.NICE)
    private ServiceManager serviceManagerMock;
    @Mock
    private ElasticsearchClientFactory clientFactoryMock;
    @Mock(type=MockType.NICE)
    private ElasticsearchClientImplementor clientMock;
    @Mock
    private ElasticsearchDialectFactory dialectFactoryMock;
    @Mock(type=MockType.NICE)
    private ElasticsearchDialect dialectMock;
    private DefaultElasticsearchService service = new DefaultElasticsearchService();

    @Test
    public void propertyMasking() throws Exception {
        Capture propertiesCapture = new Capture();
        EasyMock.expect((Object)this.contextMock.getServiceManager()).andReturn((Object)this.serviceManagerMock).anyTimes();
        EasyMock.expect((Object)this.serviceManagerMock.requestReference((Class)EasyMock.anyObject())).andAnswer(() -> new ServiceReference(this.serviceManagerMock, (Class)EasyMock.getCurrentArguments()[0])).anyTimes();
        EasyMock.expect((Object)this.serviceManagerMock.requestService(ElasticsearchClientFactory.class)).andReturn((Object)this.clientFactoryMock);
        EasyMock.expect((Object)this.clientFactoryMock.create((Properties)EasyMock.capture((Capture)propertiesCapture))).andReturn((Object)this.clientMock);
        EasyMock.expect((Object)this.serviceManagerMock.requestService(ElasticsearchDialectFactory.class)).andReturn((Object)this.dialectFactoryMock);
        EasyMock.expect((Object)this.dialectFactoryMock.createDialect((ElasticsearchClient)EasyMock.anyObject(), (Properties)EasyMock.anyObject())).andReturn((Object)this.dialectMock);
        EasyMock.expect((Object)this.dialectMock.createGsonBuilderBase()).andAnswer(GsonBuilder::new).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.contextMock, this.serviceManagerMock, this.clientFactoryMock, this.clientMock, this.dialectFactoryMock, this.dialectMock});
        Properties properties = new Properties();
        properties.setProperty("1", "1");
        properties.setProperty("hibernate.search.2", "2");
        properties.setProperty("hibernate.search.elasticsearch.3", "3");
        properties.setProperty("hibernate.search.default.elasticsearch.4", "4");
        this.service.start(properties, this.contextMock);
        Properties maskedProperties = (Properties)propertiesCapture.getValue();
        this.assertProperty(maskedProperties, "2").isEqualTo((Object)"2");
        this.assertProperty(maskedProperties, "elasticsearch.3").isEqualTo((Object)"3");
        this.assertProperty(maskedProperties, "elasticsearch.4").isEqualTo((Object)"4");
        for (String originalName : properties.stringPropertyNames()) {
            this.assertProperty(maskedProperties, originalName).isNull();
        }
        this.assertProperty(maskedProperties, "3").isNull();
        this.assertProperty(maskedProperties, "4").isNull();
        this.assertProperty(maskedProperties, "default.elasticsearch.4").isEqualTo((Object)"4");
    }

    private AbstractCharSequenceAssert<?, String> assertProperty(Properties maskedProperties, String name) {
        return (AbstractCharSequenceAssert)Assertions.assertThat((String)maskedProperties.getProperty(name)).as("Property from masked properties '" + name + "'", new Object[0]);
    }
}

